% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_Gaussian}
\alias{simulate_Gaussian}
\title{simulate Gaussian data}
\usage{
simulate_Gaussian(
  ntrain = 300,
  ntest = 3000,
  p = 1000,
  snr = 1,
  rho = 0.8,
  sparsity = 0.1,
  homecourt = FALSE
)
}
\arguments{
\item{ntrain}{number of training examples.}

\item{ntest}{number of test examples.}

\item{p}{number of features.}

\item{snr}{desired SNR (signal-to-noise ratio).}

\item{rho}{for \code{homecourt=TRUE} 'rho' controls the autocorrelation between variables. Variables k units apart have correlation \code{rho^k}.}

\item{sparsity}{fraction of variables with nonzero coefficients.}

\item{homecourt}{logical; if \code{TRUE} then correlated features, with a special boost for large coefficients, mimicking the uniLasso two-stage algorithm.}
}
\value{
a list with components "x", "y", "xtest", "ytest", "mutest", and "sigma", where "mutest" is the true test mean, and "ytest <- mutest + rnorm(ntest)*sigma."
}
\description{
A simulator that builds a training and test set with particular characteristics, as used in our "uniLasso" paper.
}
\examples{
dat = simulate_Gaussian(300,3000,p=500,snr=1.2)
fit = cv.uniLasso(dat$x, dat$y)
mse = mean( (predict(fit, dat$xtest)- dat$mutest)^2)
}
