% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_is_ordered}
\alias{umx_is_ordered}
\title{Test if one or more variables in a dataframe are ordered}
\usage{
umx_is_ordered(
  df,
  names = FALSE,
  strict = TRUE,
  binary.only = FALSE,
  ordinal.only = FALSE,
  continuous.only = FALSE,
  summaryObject = FALSE
)
}
\arguments{
\item{df}{A \code{\link[=data.frame]{data.frame()}} or \code{\link[OpenMx:mxData]{OpenMx::mxData()}} to look in for ordinal variables (if you offer a
matrix or vector, it will be upgraded to a dataframe)}

\item{names}{whether to return the names of ordinal variables, or a binary (T,F) list (default = FALSE)}

\item{strict}{whether to stop when unordered factors are found (default = TRUE)}

\item{binary.only}{only count binary factors (2-levels) (default = FALSE)}

\item{ordinal.only}{only count ordinal factors (3 or more levels) (default = FALSE)}

\item{continuous.only}{use with names = TRUE to get the names of the continuous variables}

\item{summaryObject}{whether to return a nice summary object. Overrides other settings (FALSE)}
}
\value{
\itemize{
\item vector of variable names or Booleans
}
}
\description{
Return the names of any ordinal variables in a dataframe
}
\examples{
x = data.frame(ordered(rbinom(100,1,.5))); names(x) = c("x")
umx_is_ordered(x, summaryObject= TRUE) # all ordered factors including binary
tmp = mtcars

tmp$cyl = ordered(mtcars$cyl) # ordered factor
tmp$vs = ordered(mtcars$vs) # binary factor
umx_is_ordered(tmp) # true/false
umx_is_ordered(tmp, strict=FALSE)
umx_is_ordered(tmp, names = TRUE)
umx_is_ordered(tmp, names = TRUE, binary.only = TRUE)
umx_is_ordered(tmp, names = TRUE, ordinal.only = TRUE)
umx_is_ordered(tmp, names = TRUE, continuous.only = TRUE)
umx_is_ordered(tmp, continuous.only = TRUE)

x = umx_is_ordered(tmp, summaryObject= TRUE)

isContinuous = !umx_is_ordered(tmp)
\dontrun{
# nb: By default, unordered factors cause a message...
tmp$gear = factor(mtcars$gear) # Unordered factor
umx_is_ordered(tmp)
umx_is_ordered(tmp, strict = FALSE) # compare: no warning

# also: not designed to work on single variables...
umx_is_ordered(tmp$cyl)
# Do this instead...
umx_is_ordered(tmp[, "cyl", drop= FALSE])
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Check or test: 
\code{\link{umx}},
\code{\link{umx_check_names}()},
\code{\link{umx_is_class}()},
\code{\link{umx_is_endogenous}()},
\code{\link{umx_is_exogenous}()},
\code{\link{umx_is_numeric}()}
}
\concept{Check or test}
