% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxSummarizeTwinData}
\alias{umxSummarizeTwinData}
\title{Summarize twin data}
\usage{
umxSummarizeTwinData(
  data = NULL,
  selVars = NULL,
  sep = "_T",
  zyg = "zygosity",
  age = "age",
  MZ = NULL,
  DZ = NULL,
  MZFF = "MZFF",
  DZFF = "DZFF",
  MZMM = "MZMM",
  DZMM = "DZMM",
  DZOS = "DZOS",
  digits = 2,
  report = c("markdown", "html")
)
}
\arguments{
\item{data}{The twin data.}

\item{selVars}{Collection of variables to report on, e.g. c("wt", "ht").}

\item{sep}{The separator string that will turn a variable name into a twin variable name, default= "_T" for wt_T1 and wt_T2.}

\item{zyg}{The zygosity column in the dataset (default "zygosity").}

\item{age}{The age column in the dataset (default "age")}

\item{MZ}{Set level in zyg corresponding to MZ for two group case (defaults to using 5-group case).}

\item{DZ}{Set level in zyg corresponding to DZ for two group case (defaults to using 5-group case).}

\item{MZFF}{The level of zyg corresponding to MZ FF pairs: default= "MZFF".}

\item{DZFF}{The level of zyg corresponding to DZ FF pairs: default= "DZFF".}

\item{MZMM}{The level of zyg corresponding to MZ MM pairs: default= "MZMM".}

\item{DZMM}{The level of zyg corresponding to DZ MM pairs: default= "DZMM".}

\item{DZOS}{The level of zyg corresponding to DZ OS pairs: default= "DZOS".}

\item{digits}{Rounding precision of the report (default 2).}

\item{report}{What to return (default = 'markdown'). Use 'html' to open a web table.}
}
\value{
\itemize{
\item formatted table, e.g. in markdown.
}
}
\description{
Produce a summary of wide-format twin data, showing the number of individuals, the mean and SD for each trait, and the correlation for each twin-type.

Set MZ and DZ to summarize the two-group case.
}
\examples{
data(twinData)
umxSummarizeTwinData(twinData, sep = "", selVars = c("wt", "ht"))
MZs = c("MZMM", "MZFF"); DZs = c("DZFF","DZMM", "DZOS")
umxSummarizeTwinData(twinData, sep = "", selVars = c("wt", "ht"), MZ = MZs, DZ = DZs)
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[=umxAPA]{umxAPA()}}
}

Other Twin Modeling Functions: 
\code{\link{power.ACE.test}()},
\code{\link{umx}},
\code{\link{umxACE}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxCP}()},
\code{\link{umxDiffMZ}()},
\code{\link{umxDiscTwin}()},
\code{\link{umxDoC}()},
\code{\link{umxDoCp}()},
\code{\link{umxGxE}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxIP}()},
\code{\link{umxMRDoC}()},
\code{\link{umxReduce}()},
\code{\link{umxReduceACE}()},
\code{\link{umxReduceGxE}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umxSummaryACE}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryDoC}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()},
\code{\link{umxTwinMaker}()}
}
\concept{Twin Modeling Functions}
