% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uis_get_entities.R
\name{uis_get_entities}
\alias{uis_get_entities}
\title{Get geographical entities from UIS API}
\usage{
uis_get_entities(version = NULL)
}
\arguments{
\item{version}{Character. The API version to use. If NULL (default), the
API's default version will be used. See \link{uis_get_versions} for a list
of supported versions.}
}
\value{
A data frame with information about geographical entities:
\item{entity_id}{Character. The unique identifier for the entity.}
\item{entity_name}{Character. The name of the geographical entity.}
\item{entity_type}{Character. The type of entity (e.g., country, region).}
\item{region_group}{Character. Information about the region
grouping.}
}
\description{
Retrieves information about geographical entities (countries, regions, etc.)
available in the UNESCO Institute for Statistics (UIS) API.
}
\examples{
\donttest{
# Download entities for default version
uis_get_entities()

# Download entities for a specific version
uis_get_entities("20240910-b5ad4d82")
}

}
