% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validators.R
\name{validate_relationships}
\alias{validate_relationships}
\title{Validate relationships against available datasources and fields}
\usage{
validate_relationships(parser, strict = FALSE)
}
\arguments{
\item{parser}{A \code{TwbParser}-like object that exposes:
\code{get_relationships()}, \code{get_datasources()}, \code{get_fields()},
and \code{get_calculated_fields()}. (S3/R6 both fine.)}

\item{strict}{Logical. Reserved for future table-scoped checks that can be
overly conservative with federated sources. Currently not used.}
}
\value{
A list with:
\describe{
\item{ok}{\code{TRUE} if no issues; \code{FALSE} otherwise.}
\item{issues}{A named list of tibbles. Possible elements:
\itemize{
\item \code{unknown_tables}: endpoints not found among known tables.
\item \code{unknown_fields}: predicate fields not found in the field pool.
}
}
}
}
\description{
Checks that relationship endpoints reference known datasource tables and that
the predicate fields appear somewhere in the workbook (calculated, raw, or
parameter fields), using a lenient token match (e.g., \verb{INT([GEOID])} = \code{GEOID}).
}
\examples{
twb <- system.file("extdata", "test_for_wenjie.twb", package = "twbparser")
if (nzchar(twb) && file.exists(twb)) {
  parser <- TwbParser$new(twb)
  res <- validate_relationships(parser)
  if (!res$ok) print(res$issues)
}


}
