% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tvem.R
\name{plot.tvem}
\alias{plot.tvem}
\title{plot.tvem:  Produce plots for a tvem model.}
\usage{
\method{plot}{tvem}(
  x,
  use_panes = TRUE,
  which_plot = NULL,
  diagnostics = FALSE,
  exponentiate = FALSE,
  ...
)
}
\arguments{
\item{x}{The TVEM object to be plotted.}

\item{use_panes}{Whether to plot multiple coefficient
functions in a single image.}

\item{which_plot}{The coefficient number to plot,
if only one plot is desired at a time.}

\item{diagnostics}{If this is set to TRUE, then 
instead of plotting coefficient functions,
the function will show a histogram of residuals 
and a plot of fitted values versus
residuals.  These may be useful in checking for 
outliers or skew in TVEM with a numeric
outcome.  They are not likely to be as useful 
in TVEM with a binary or other discrete outcome.}

\item{exponentiate}{If this is set to TRUE and if
the TVEM had a binary outcome, then the exponentiated 
coefficient functions (representing odds and odds
ratios) will be plotted rather than the usual
coefficient functions (representing log odds and log
odds ratios).}

\item{...}{Further arguments currently not supported}
}
\description{
Produces plots from a tvem object produced by 
the tvem function.  These plots will be shown on the default
output device (likely the screen);  they can of course be 
written to a file instead, by preceding the call to plot.tvem 
with a call to png(), pdf(), or other R graphic file output functions.
}
