% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stamp-par.R, R/stamp.R
\name{stamp_par}
\alias{stamp_par}
\alias{stamp}
\title{Anytime univariate STAMP algorithm Parallel version}
\usage{
stamp_par(
  ...,
  window_size,
  exclusion_zone = getOption("tsmp.exclusion_zone", 1/2),
  verbose = getOption("tsmp.verbose", 2),
  s_size = Inf,
  n_workers = 2,
  weight = NULL
)

stamp(
  ...,
  window_size,
  exclusion_zone = getOption("tsmp.exclusion_zone", 1/2),
  verbose = getOption("tsmp.verbose", 2),
  s_size = Inf,
  weight = NULL
)
}
\arguments{
\item{\dots}{a \code{matrix} or a \code{vector}. If a second time series is supplied it will be a join matrix
profile.}

\item{window_size}{an \code{int}. Size of the sliding window.}

\item{exclusion_zone}{a \code{numeric}. Size of the exclusion zone, based on window size (default is
\code{1/2}). See details.}

\item{verbose}{an \code{int}. See details. (Default is \code{2}).}

\item{s_size}{a \code{numeric}. for anytime algorithm, represents the size (in observations) the
random calculation will occur (default is \code{Inf}).}

\item{n_workers}{an \code{int}. Number of workers for parallel. (Default is \code{2}).}

\item{weight}{a \code{vector} of \code{numeric} or \code{NULL} with the same length of the \code{window_size}. This is
a MASS extension to weight the query.}
}
\value{
Returns a \code{MatrixProfile} object, a \code{list} with the matrix profile \code{mp}, profile index \code{pi}
left and right matrix profile \code{lmp}, \code{rmp} and profile index \code{lpi}, \code{rpi}, window size \code{w} and
exclusion zone \code{ez}.
}
\description{
Computes the best so far Matrix Profile and Profile Index for Univariate Time Series.
}
\details{
The Matrix Profile, has the potential to revolutionize time series data mining because of its
generality, versatility, simplicity and scalability. In particular it has implications for time
series motif discovery, time series joins, shapelet discovery (classification), density
estimation, semantic segmentation, visualization, rule discovery, clustering etc. The anytime
STAMP computes the Matrix Profile and Profile Index in such manner that it can be stopped before
its complete calculation and return the best so far results allowing ultra-fast approximate
solutions. \code{verbose} changes how much information is printed by this function; \code{0} means nothing,
\code{1} means text, \code{2} adds the progress bar, \code{3} adds the finish sound. \code{exclusion_zone} is used to
avoid  trivial matches; if a query data is provided (join similarity), this parameter is ignored.
}
\section{Functions}{
\itemize{
\item \code{stamp_par()}: Parallel version.

\item \code{stamp()}: Single thread version.

}}
\examples{
mp <- stamp(mp_toy_data$data[1:200, 1], window_size = 30, verbose = 0)
\donttest{

#' # using threads
mp <- stamp_par(mp_toy_data$data[1:200, 1], window_size = 30, verbose = 0)

ref_data <- mp_toy_data$data[, 1]
query_data <- mp_toy_data$data[, 2]
# self similarity
mp <- stamp(ref_data, window_size = 30, s_size = round(nrow(ref_data) * 0.1))
# join similarity
mp <- stamp(ref_data, query_data, window_size = 30, s_size = round(nrow(query_data) * 0.1))
}

}
\references{
\itemize{
\item Yeh CCM, Zhu Y, Ulanova L, Begum N, Ding Y, Dau HA, et al. Matrix profile I: All
pairs similarity joins for time series: A unifying view that includes motifs, discords and
shapelets. Proc - IEEE Int Conf Data Mining, ICDM. 2017;1317-22.
}

\itemize{
\item Zhu Y, Imamura M, Nikovski D, Keogh E. Matrix Profile VII: Time Series Chains: A
New Primitive for Time Series Data Mining. Knowl Inf Syst. 2018 Jun 2;1-27.
}

Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
\seealso{
Other matrix profile computations: 
\code{\link{mstomp_par}()},
\code{\link{scrimp}()},
\code{\link{stomp_par}()},
\code{\link{tsmp}()},
\code{\link{valmod}()}
}
\concept{matrix profile computations}
