% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcestpars_function.R
\name{mcmcestpars}
\alias{mcmcestpars}
\title{mcmcestpars}
\usage{
mcmcestpars(
  data,
  xreg = "cumcases",
  IP = 2,
  regtype = "gaussian",
  sigmamax = 3,
  seasonality = "standard",
  userYhat = numeric(),
  update.iter = 10000,
  n.iter = 30000,
  n.chains = 3,
  n.adapt = 1000,
  burn.in = 100,
  sbar = NULL,
  alpha = NULL,
  printon = F
)
}
\arguments{
\item{data}{The data frame containing cases and interpolated births and populations.}

\item{xreg}{The x-axis for the regression. Options are 'cumcases' and 'cumbirths'. Defaults to 'cumcases'.}

\item{IP}{The infectious period in weeks. Defaults to 2 weeks.}

\item{regtype}{The type of regression used in susceptible reconstruction.
Options are 'gaussian', 'lm' (linear model), 'spline' (smooth.spline with 2.5 degrees freedom),
'lowess' (with f = 2/3, iter = 1), 'loess' (degree 1), and 'user' which is just a user inputed vector.
Defaults to 'gaussian' and if that fails then defaults to loess.}

\item{sigmamax}{The inverse kernal width for the gaussian regression. Default is 3.
Smaller, stochastic outbreaks tend to need a lower sigma.}

\item{seasonality}{The type of contact to use. Options are standard for 52/IP point contact or schoolterm for just a two point on off contact or none for a single contact parameter. Defaults to standard.}

\item{userYhat}{The inputed regression vector if regtype='user'. Defaults to NULL.}

\item{update.iter}{Number of MCMC iterations to use in the update aspect. Default is 10000.}

\item{n.iter}{Number of MCMC iterations to use. Default is 30000.}

\item{n.chains}{Number of MCMC chains to use. Default is 3.}

\item{n.adapt}{Adaptive number for MCMC. Default is 1000.}

\item{burn.in}{Burn in number. Default is 100.}

\item{sbar}{The mean number of susceptibles. Defaults to NULL, i.e. the function estimates sbar.}

\item{alpha}{The mixing parameter. Defaults to NULL, i.e. the function estimates alpha.}

\item{printon}{Whether to show diagnostic prints or not, defaults to FALSE.}
}
\description{
This function computes the set up to run the TSIR model, i.e. reconstructes susecptibles and
estimates beta and alpha using MCMC computations. Used the same way as estpars.
}
