% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSModelDynGompertzReinit.R
\docType{class}
\name{SSModelDynGompertzReinit-class}
\alias{SSModelDynGompertzReinit-class}
\alias{SSModelDynGompertzReinit}
\title{Class for re-initialised dynamic Gompertz curve model}
\description{
This class allows the implementation of the reinitialisation
procedure described in the vignette and summarised below.
Let \eqn{t=r} denote the re-initialization date and \eqn{r_0} denote the
date at which the cumulative series is set to 0. As the growth rate of
cumulative cases is defined as \eqn{g_t\equiv \frac{y_t}{Y_{t-1}}}, we have:
\deqn{\ln g_t = \ln y_t - \ln Y_{t-1} \;\;\;\; t=1, \ldots, r}
\deqn{\ln g_t^r = \ln y_t - \ln Y_{t-1}^r \;\;\;\; t=r+1, \ldots, T}
\deqn{Y_{t}^{r}=Y_{t-1}^{r}+y_{t}  \;\;\;\; t=r,\ldots,T}
where \eqn{Y_{t}^{r}} is the cumulative cases after re-initialization. We
choose to set the cumulative cases to zero at \eqn{r_0=r-1, Y_{r-1}^{r}=0},
such that the growth rate of cumulative cases is available from \eqn{t=r+1}
onwards.
We reinitialise the model by specifying the prior distribution for the
initial states appropriately. See the vignette for details.

\subsection{Methods}{
\itemize{
\item{\code{new(Y, q = NULL, reinit.date=NULL, original.results=NULL,
use.presample.info=TRUE)} Create an instance of the
\code{SSModelDynGompertzReinit} class.
\subsection{Parameters}{\itemize{
\item{\code{Y} The cumulated variable.}
\item{\code{q} The signal-to-noise ratio (ratio of slope to irregular
variance). Defaults to \code{'NULL'}, in which case no signal-to-noise
ratio will be imposed. Instead, it will be estimated.}
\item{\code{reinit.date} The reinitialisation date \eqn{r}. Should be
specified as an object of class \code{"Date"}. Must be specified.}
\item{\code{original.results} Rather than re-estimating the model up
to the \code{reinit.date}, a \code{FilterResults} class object can be
specified here and the parameters for the reinitialisation will be taken
from this object. Default is \code{NULL}. This parameter is optional.}
\item{\code{use.presample.info}  Logical value denoting whether or
not to use information from before the reinitialisation date in the
reinitialisation procedure. Default is \code{TRUE}. If \code{FALSE}, the
model is estimated from scratch from the reinitialisation date and no
attempt to use information from before the reinitialisation date is made.}
}}
}
\item{\code{get_model(y, q=NULL, sea.type = NULL, sea.period)} Retrieves
the model object, which is a dynamic Gompertz curve model reinitialised at
\code{self$reinit.date}.
\subsection{Parameters}{\itemize{
\item{\code{y} The cumulated variable.}
\item{\code{q} The signal-to-noise ratio (ratio of slope to irregular
variance). Defaults to \code{'NULL'}, in which case no signal-to-noise ratio
will be imposed. Instead, it will be estimated.}
\item{\code{sea.type} Seasonal type. Options are \code{'trigonometric'} and
\code{'none'}. \code{'trigonometric'} will yield a model with a
trigonometric seasonal component and \code{'none'} will yield a model with
no seasonal component.}
\item{\code{sea.period}  The period of seasonality. For a day-of-the-week
effect with daily data, this would be 7. Not required if
\code{sea.type = 'none'}.}
}}
\subsection{Return Value}{\code{KFS} model object.}}
}
}
}

\examples{
library(tsgc)
data(gauteng,package="tsgc")
idx.est <- zoo::index(gauteng) <= as.Date("2021-05-20")

# Specify a model
model.reinit <- SSModelDynGompertzReinit$new(Y = gauteng[idx.est], q = 0.005,
  reinit.date = as.Date("2021-04-29"))
# Estimate a specified model
res.reinit <- model.reinit$estimate()

## Alternatively, we could feed in a prior results object rather than a
## reinitialisation date. The results are identical to the above.

# Specify initial model
idx.orig <- zoo::index(gauteng) <= as.Date("2021-04-29")
model.orig <- SSModelDynamicGompertz$new(Y = gauteng[idx.orig], q = 0.005)
res.orig <- model.orig$estimate()
# Estimate a specified model
model.reinit2 <- SSModelDynGompertzReinit$new(Y = gauteng[idx.est],
q = 0.005, reinit.date = as.Date("2021-04-29"), original.results = res.orig)
res.reinit2 <- model.reinit2$estimate()

}
