% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tseffects.R
\name{general.calculator}
\alias{general.calculator}
\title{Generate the generalized effect formulae for an autoregressive distributed lag (ADL) model, given pulse effects and shock/treatment history}
\usage{
general.calculator(d.x, d.y, h, limit, pulses)
}
\arguments{
\item{d.x}{the order of differencing of the x variable in the ADL model. (Generally, this is the same x variable used in \code{pulse.calculator})}

\item{d.y}{the order of differencing of the y variable in the ADL model. (Generally, this is the same y variable used in \code{pulse.calculator})}

\item{h}{an integer for the shock/treatment history. \code{h} determines the counterfactual series that will be applied to the independent variable. -1 represents a pulse. 0 represents a step. For others, see Vande Kamp, Jordan, and Rajan}

\item{limit}{an integer for the number of periods (s) to determine the generalized effect (beginning at 0)}

\item{pulses}{a list of pulse effect formulae used to construct the generalized effect formulae. We expect this will be provided by \code{pulse.calculator}}
}
\value{
a list of \code{limit} + 1 \code{mpoly} formulae containing the generalized effect formula in each period
}
\description{
Generate the generalized effect formulae for an autoregressive distributed lag (ADL) model, given pulse effects and shock/treatment history
}
\details{
\code{general.calculator} does no calculation. It generates a list of \code{mpoly} formulae that contain variable names that represent the generalized effect in each period. The expectation is that these will be evaluated using coefficients from an object containing an ADL model with corresponding variables. Note: \code{mpoly} does not allow variable names with a .; variables passed to \code{general.calculator} should not include this character
}
\examples{
# ADL(1,1)
x.lags <- c("x" = 0, "l_1_x" = 1) # lags of x
y.lags <- c("l_1_y" = 1)
s <- 5
pulse.effects <- pulse.calculator(x.vrbl = x.lags, y.vrbl = y.lags, limit = s)
# Assume that both x and y are in levels and we want a pulse treatment
general.pulse.effects <- general.calculator(d.x = 0, d.y = 0, 
							h = -1, limit = s, pulses = pulse.effects)
general.pulse.effects
# Apply a step treatment
general.step.effects <- general.calculator(d.x = 0, d.y = 0, 
							h = 0, limit = s, pulses = pulse.effects)
general.step.effects
}
\author{
Soren Jordan, Garrett N. Vande Kamp, and Reshi Rajan
}
\keyword{utilities}
