% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tseffects.R
\name{pte.calculator}
\alias{pte.calculator}
\title{Generate the Pulse Treatment Effect (PTE) for a given autoregressive distributed lag (ADL) model}
\usage{
pte.calculator(x.vrbl, y.vrbl, limit)
}
\arguments{
\item{x.vrbl}{a named vector of the x variables and corresponding lag orders in an ADL model}

\item{y.vrbl}{a named vector of the (lagged) y variables and corresponding lag orders in an ADL model}

\item{limit}{an integer for the number of periods (s) to determine the PTE (beginning at 0)}
}
\value{
a list of limit + 1 \code{mpoly} formulae containing the PTE in each period
}
\description{
Generate the Pulse Treatment Effect (PTE) for a given autoregressive distributed lag (ADL) model
}
\details{
\code{pte.calculator} does no calculation. It generates a list of \code{mpoly} formulae that contain variable names that represent the PTE in each period. The expectation is that these will be evaluated using coefficients from an object containing an ADL model with corresponding variables. It is used as a subfunction in both \code{GDTE.adl.plot} and \code{GDTE.gecm.plot}. Note: \code{mpoly} does not allow variable names with a .; variables passed to \code{GDTE.calculator} should not include this character
}
\examples{
# ADL(1,1)
x.lags <- c("x" = 0, "l_1_x" = 1) # lags of x
y.lags <- c("l_1_y" = 1)
s <- 5
PTEs <- pte.calculator(x.vrbl = x.lags, y.vrbl = y.lags, limit = s)
PTEs
}
\author{
Soren Jordan, Garrett N. Vande Kamp, and Reshi Rajan
}
\keyword{utilities}
