% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HACLasso.r
\name{lambdaCalculationLoad}
\alias{lambdaCalculationLoad}
\title{\code{lambdaCalculationLoad} is an auxiliary function for rlassoLoad; it calculates the penalty parameters
                              with predefined loadings.}
\source{
Victor Chernozhukov, Chris Hansen, Martin Spindler (2016). hdm: High-Dimensional Metrics,
R Journal, 8(2), 185-199. URL https://journal.r-project.org/archive/2016/RJ-2016-040/index.html.
}
\usage{
lambdaCalculationLoad(
  X.dependent.lambda = FALSE,
  c = 2,
  gamma = 0.1,
  load,
  bns,
  lns,
  nboot,
  y = NULL,
  x = NULL
)
}
\arguments{
\item{X.dependent.lambda}{Logical, TRUE, if the penalization parameter depends on the design 
of the matrix x. FALSE, if independent of the design matrix (default).}

\item{c}{Constant for the penalty with default c = 2 .}

\item{gamma}{Constant for the penalty with default gamma=0.1.}

\item{load}{Penalty loadings, vector of length p (no. of regressors).}

\item{bns}{Block length.}

\item{lns}{Number of blocks.}

\item{nboot}{Number of bootstrap iterations.}

\item{y}{Residual which is used for calculation of the variance or the data-dependent penalty.}

\item{x}{Regressors (vector, matrix or object can be coerced to matrix).}
}
\value{
\item{lambda0}{Penalty term}
\item{Ups0}{Penalty loadings, vector of length p (no. of regressors)}
\item{lambda}{This is lambda0 * Ups0}
\item{penalty}{Summary of the used penalty function}
}
\description{
\code{lambdaCalculationLoad} is an auxiliary function for rlassoLoad; it calculates the penalty parameters
                              with predefined loadings.
}
