% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-trending_model.R
\name{fit.trending_model}
\alias{fit.trending_model}
\title{Fit method for trending_model objects}
\usage{
\method{fit}{trending_model}(x, data, as_tibble = TRUE, ...)
}
\arguments{
\item{x}{An \R object}

\item{data}{A data frame containing the data to fit.}

\item{as_tibble}{Should the output be converted to a tibble subclass.}

\item{...}{Not currently used.}
}
\value{
If \code{as_tibble = FALSE}, then a \code{trending_fit} object is returned.
This is a list subclass with entries:
\itemize{
\item result: the resulting fit from calling the underlying model
directly, i.e.
\itemize{
\item \code{lm_model}: a fitted model object of class \code{\link[stats:lm]{lm}}
\item \code{glm_model}: a fitted model object of class \code{\link[stats:glm]{glm}}
\item \code{glm_nb_model}: a fitted model object of class \code{\link[MASS:glm.nb]{negbin}}
\item \code{brm_model}: An object of class \code{\link[brms:brm]{brmsfit}}
}

\code{NULL} if fitting fails.
\item warnings: any warnings generated during fitting
\item errors: any errors generated during fitting
}

If \code{as_tibble = TRUE}, a \code{trending_fit_tbl} object which is a
\code{\link[tibble:tibble]{tibble}} subclass with one row for each model and
columns 'result', 'warnings' and 'errors' with contents as above.
}
\description{
Fits the specified model to the input data
}
\examples{
x = rnorm(100, mean = 0)
y = rpois(n = 100, lambda = exp(1.5 + 0.5*x))
dat <- data.frame(x = x, y = y)

poisson_model <- glm_model(y ~ x , family = poisson)
negbin_model <- glm_nb_model(y ~ x)

fit(poisson_model, dat)
fit(negbin_model, dat)
fit(list(poisson_model, negbin_model), dat)
fit(list(pm = poisson_model, nm = negbin_model), dat)

}
\seealso{
\code{\link[=fit.list]{fit.list()}}
}
\author{
Tim Taylor
}
