% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_norm.R
\name{scale_norm}
\alias{scale_norm}
\title{Performs transformation on continuous variables.}
\usage{
scale_norm(x, trans_type = c("percentize", "normalize", "scale", "none"))
}
\arguments{
\item{x}{Numeric vector.}

\item{trans_type}{Character string of 'normalize', 'scale' or 'none'.
If 'scale', subtract the mean and divide by the standard deviation.
If 'normalize', i.e., max-min normalize, subtract the min and divide by the max.
If 'none', no transformation is applied.
More information on what transformation to choose can be acquired here:
https://cran.rstudio.com/package=heatmaply/vignettes/heatmaply.html#data-transformation-scaling-normalize-and-percentize}
}
\value{
Numeric vector of the transformed `x`.
}
\description{
Performs transformation on continuous variables for the heatmap color scales.
}
\examples{
scale_norm(1:5)
scale_norm(1:5, "normalize")

}
