% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrunc.R, R/ptrunc.R, R/qtrunc.R, R/rtrunc.R
\name{truncatedDistribution}
\alias{truncatedDistribution}
\alias{dtrunc}
\alias{ptrunc}
\alias{qtrunc}
\alias{rtrunc}
\title{Truncated Distributions}
\usage{
dtrunc(x, distr, ..., low = -Inf, high = Inf, log = FALSE)

ptrunc(q, distr, ..., low = -Inf, high = Inf, lower.tail = TRUE, log.p = FALSE)

qtrunc(p, distr, ..., low = -Inf, high = Inf, lower.tail = TRUE, log.p = FALSE)

rtrunc(n, distr, ..., low = -Inf, high = Inf)
}
\arguments{
\item{x}{Vector of quantiles.}

\item{distr}{Character value specifying the desired probability distribution.}

\item{...}{Additional arguments passed to the non-truncated distribution functions.}

\item{low}{Numeric value specifying the lower truncation bound.}

\item{high}{Numeric value specifying the upper truncation bound.}

\item{log}{Logical; if TRUE, log densities are returned.}

\item{q}{Vector of quantiles.}

\item{lower.tail}{Logical; if TRUE (default), probabilities are P(X <= x) otherwise, P(X > x).}

\item{log.p}{Currently ignored.}

\item{p}{Vector of probabilities.}

\item{n}{A positive integer specifying the desired number of random variates.}
}
\value{
\code{dtrunc} returns a vector of densities.

\code{ptrunc} returns a vector of probabilities.

\code{qtrunc} returns a vector of quantiles.

\code{rtrunc} returns a vector of random variates.
}
\description{
Truncated probability density function, truncated cumulative density function, inverse truncated cumulative density function, and random variates from a truncated distribution.
}
\details{
The non truncated distribution functions are assumed to be available. For example if the normal distribution is desired then used \code{distr='norm'}, the functions then look for 'qnorm', 'pnorm', etc.

The truncation interval is (low, high], which only matters for discrete distribution.

The random variates are produced using the direct method (see Casella and Berger 2002).
}
\examples{

## dtrunc
# not truncted
dnorm(5,mean=5)
dtrunc(x=5,distr='norm',mean=5)
# truncated
dtrunc(x=5,distr='norm',mean=5,low=4, high=5.5)



## ptrunc
#not truncated
pgamma(2, shape=3, rate=2)
ptrunc(2, distr = 'gamma', shape=3, rate=2)
# truncated
ptrunc(2, distr = 'gamma', shape=3, rate=2, low=1, high=5)

## upper tail
# not truncated
pgamma(2, shape=3, rate=2,lower.tail=FALSE)
ptrunc(2, distr='gamma', shape=3, rate=2, lower.tail=FALSE)
# truncated
ptrunc(2, distr='gamma', shape=3, rate=2, low=1, high=5, lower.tail=FALSE)



## qtrunc
#not truncated
qnorm(p=.975)
qtrunc(p=.975,distr='norm')
# truncted
qtrunc(p=.975,distr='norm', low=0, high=1)

## upper tail
# not truncted
qnorm(p=.975,lower.tail=FALSE)
qtrunc(p=.975, distr='norm', lower.tail=FALSE)
# truncated
qtrunc(p=.975, distr='norm', low=0, high=1, lower.tail=FALSE)

## rtrunc
rtrunc(n=5, distr = 'gamma', shape=3, rate=2, low=2, high=5)
}
\references{
G. Casella and R. L. Berger. Statistical inference. Vol. 2. Duxbury Pacific Grove, CA, 2002.
}
