% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-filter.R
\name{select_lambda}
\alias{select_lambda}
\title{Selecting lambda}
\usage{
select_lambda(
  freq = c("quarterly", "annual", "monthly", "weekly"),
  type = c("rot", "ru2002")
)
}
\arguments{
\item{freq}{\verb{[character: "quarterly"]}

The frequency of the dataset.}

\item{type}{\verb{[character: "rot"]}

The methodology to select lambda.}
}
\description{
Approaches to selecting lambda.
}
\details{
Rule of thumb is from Hodrick and Prescot (1997):
\itemize{
\item Lambda = 100*(number of periods in a year)^2
}
\itemize{
\item Annual data = 100 x 1^2 = 100
\item Quarterly data = 100 x 4^2 = 1,600
\item Monthly data = 100 x 12^2 = 14,400
\item Weekly data = 100 x 52^2 = 270,400
\item Daily data = 100 x 365^2 = 13,322,500
}

Ravn and Uhlig (2002) state that lambda  should vary by the fourth power of the frequency observation ratio;
\itemize{
\item Lambda = 6.25 x (number of periods in a year)^4
}

Thus, the rescaled default values for lambda are:
\itemize{
\item Annual data = 1600 x 1^4 = 6.25
\item Quarterly data = 1600 x 4^4= 1600
\item Monthly data = 1600 x 12^4= 129,600
\item Weekly data = 1600 x 12^4 = 33,177,600
}
}
\references{
Hodrick, R. J., & Prescott, E. C. (1997). Postwar US business cycles:
an empirical investigation. Journal of Money, credit, and Banking, 1-16.

Ravn, M. O., & Uhlig, H. (2002). On adjusting the Hodrick-Prescott
filter for the frequency of observations. Review of economics and statistics, 84(2), 371-376.
}
