% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transPlotWR.R
\name{transPlotWR}
\alias{transPlotWR}
\title{Plots transport profiles of replicated experiments}
\usage{
transPlotWR(trans, trend = NULL, secondary = NULL, tertiary = NULL,
  legend = FALSE, xlab = "Time (h)", ylab = expression(Phi),
  xlim = NULL, ylim = NULL, xbreaks = NULL, ybreaks = NULL,
  lin.secon = FALSE, sec.trend = "spline", span = 0.75,
  explicit = FALSE, size = 3, plot = TRUE, bw = FALSE, srs = NULL)
}
\arguments{
\item{trans}{List of data frames with the complete transport
information of interest species. Must be generated
using \code{\link{conc2frac}}. This is the only
non-optional parameter.}

\item{trend}{List of Non-linear regression models of the main species
transport profil. Generated using \code{\link{transTrend}}.}

\item{secondary}{List of secondary species transport data frame (see
\code{\link{conc2frac}}).}

\item{tertiary}{List of tertiary species transport data frame (see
\code{\link{conc2frac}}).}

\item{legend}{Logical. If \code{FALSE}, the default, the legend is not
included.}

\item{xlab}{Label to be used for x axis. Text and expression allowed.}

\item{ylab}{Label to be used for y axis. Text and expression allowed.}

\item{xlim}{Numeric vector of limits for X-axis.}

\item{ylim}{Numeric vector of limits for X-axis.}

\item{xbreaks}{Numeric vector of x-axis breaks.}

\item{ybreaks}{Numeric vector of x-axis breaks.}

\item{lin.secon}{Deprecated. Use \code{sec.trend = 'linear'} instead.}

\item{sec.trend}{Type of trend line to be used for secondary and tertiary
species data. Default is \code{'spline'} but
\code{'linear'}, \code{'loess'} and \code{'logarithmic'}
are also allowed.}

\item{span}{Amount of smoothing when \code{sec.tred = 'loess'}. Is a
value between 0 and 1. Default is 0.75}

\item{explicit}{Logical, if \code{FALSE}, the default, transport
informations are averaged and plotted using errorbars that
with the standard deviation values. If \code{TRUE}, all
provided data is plotted in the same graphic.}

\item{size}{Size used for points in the plot.}

\item{plot}{Logical. If \code{TRUE}, the default, the plot is printed
in the current graphical device.}

\item{bw}{Logical, if \code{FALSE}, the default, a color version of
the plot is given. If a black and white version is
required, it must be set to \code{TRUE}.}

\item{srs}{Deprecated.}
}
\value{
Plot of replicated transport profiles including all provided species
}
\description{
The function works the same way as \code{\link{transPlot}} but requires
several experimental data sets that must be concatenated in lists.
This allows the process reproducibility to be evaluated in the analysis
of the results.
}
\details{
Most \code{transmem} graphical representations are made using the package
\code{ggplot2} so the function returns a ggplot2 object that can be
assigned to a variable for further modification.
}
\examples{
  data(seawaterLiNaK)
  # Transport data frames and transport NLS regresions must be in lists
  lithium   <- list(seawaterLiNaK$Lithium.1, seawaterLiNaK$Lithium.2)
  sodium    <- list(seawaterLiNaK$Sodium.1, seawaterLiNaK$Sodium.2)
  potassium <- list(seawaterLiNaK$Potassium.1, seawaterLiNaK$Potassium.2)
  trend     <- list(transTrend(trans = seawaterLiNaK$Lithium.1),
                    transTrend(trans = seawaterLiNaK$Lithium.2))

  transPlotWR(trans = lithium, trend = trend, secondary = sodium,
              tertiary = potassium, bw = TRUE)
}
\references{
Wickham H (2016). ggplot2: Elegant Graphics for Data Analysis.
Springer-Verlag New York. ISBN 978-3-319-24277-4,
\url{https://ggplot2.tidyverse.org}.
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Eduardo Rodriguez de San Miguel, \email{erdsmg@unam.mx}
}
