% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-traffic.R
\name{fit_traffic}
\alias{fit_traffic}
\title{Fit a Gaussian CAR traffic model (speed or travel time)}
\usage{
fit_traffic(
  data,
  roads = NULL,
  A = NULL,
  segment_id_col = "segment_id",
  outcome = c("speed", "travel_time"),
  outcome_col = NULL,
  distance_col = NULL,
  per_distance = FALSE,
  transform = c("log", "identity"),
  X = NULL,
  ...
)
}
\arguments{
\item{data}{data.frame with at least `segment_id` and the outcome column.}

\item{roads}{optional; an sf object or similar that contains adjacency info already
used by your `fit_car()` pipeline (depends on your package design).}

\item{A}{adjacency matrix or object accepted by `fit_car()` (recommended explicit).}

\item{segment_id_col}{character; column in `data` used to join back to roads.}

\item{outcome}{character; one of "speed" or "travel_time".}

\item{outcome_col}{optional character; if NULL uses `outcome`.}

\item{distance_col}{optional character; used only for travel_time when per_distance=TRUE.}

\item{per_distance}{logical; only for travel_time.}

\item{transform}{character; "log" or "identity".}

\item{X}{optional design matrix; if NULL, uses intercept-only.}

\item{...}{passed to `fit_car()` (e.g., type="proper"/"icar", rho, priors, n_iter, burn, etc.)}
}
\value{
An object of class `traffic_fit` containing the underlying fit and transform metadata.
}
\description{
This is a thin wrapper around \code{fit_car()} that:
1) preprocesses the outcome (log/per-distance options),
2) fits the Gaussian CAR model,
3) returns a traffic-flavored object that can be augmented back onto roads.
}
