% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_files.R
\docType{class}
\name{FileMap-class}
\alias{FileMap-class}
\alias{FileMap}
\title{The FileMap class}
\description{
A reference class to represent a file map and handle persisting it to file.
A file map is a directory-specific dictionary keyed by file names (without
suffixes), whose values point to the actual locations of the associated
files. This saves duplicating large files such as images, in a way similar
to symbolic linking, but without requiring special file system support, and
with only one link per file set rather than one per file. The map is
serialised in YAML format to a file called \code{map.yaml} in the relevant
directory. Reading from this file happens on object creation and when the
\code{read} method is called; writing is only by an explicit call to the
\code{write} method.
}
\section{Fields}{

\describe{
\item{\code{directory}}{A character string representing the directory being mapped.}

\item{\code{map}}{A list representation of the map in memory.}
}}

\section{Methods}{

\describe{
\item{\code{dropElements(keys)}}{Remove elements with the specified keys from the in-memory map}

\item{\code{getElements(keys)}}{Return the values associated with the specified keys}

\item{\code{getFile()}}{Return the path to the map file, which may not yet exist}

\item{\code{getMap(sorted = FALSE)}}{Return the in-memory map, optionally sorted by key}

\item{\code{initialize(path = "", ...)}}{Create a FileMap object for the specified paths}

\item{\code{read()}}{Read the map file into memory}

\item{\code{setElements(keys, values)}}{Replace the specified keys with new values, which should be strings}

\item{\code{write()}}{Write the in-memory map to file, or delete the file if it is empty}
}}

