% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vision_utils.R
\name{draw_segmentation_masks}
\alias{draw_segmentation_masks}
\alias{draw_segmentation_masks.default}
\alias{draw_segmentation_masks.torch_tensor}
\alias{draw_segmentation_masks.image_with_segmentation_mask}
\title{Draw segmentation masks}
\usage{
draw_segmentation_masks(x, ...)

\method{draw_segmentation_masks}{default}(x, ...)

\method{draw_segmentation_masks}{torch_tensor}(x, masks, alpha = 0.8, colors = NULL, ...)

\method{draw_segmentation_masks}{image_with_segmentation_mask}(x, alpha = 0.5, colors = NULL, ...)
}
\arguments{
\item{x}{Tensor of shape (C x H x W) and dtype \code{uint8} or dtype \code{float}.
In case of dtype float, values are assumed to be in range \eqn{[0, 1]}.
C value for channel can only be 1 (grayscale) or 3 (RGB).}

\item{...}{Additional arguments passed to methods.}

\item{masks}{torch_tensor of shape (num_masks, H, W) or (H, W) and dtype bool.}

\item{alpha}{number between 0 and 1 denoting the transparency of the masks.}

\item{colors}{character vector containing the colors
of the boxes or single color for all boxes. The color can be represented as
strings e.g. "red" or "#FF00FF". By default, viridis colors are generated for masks}
}
\value{
torch_tensor of shape (3, H, W) and dtype uint8 of the image with segmentation masks drawn on top.
}
\description{
Draw segmentation masks with their respective colors on top of a given RGB tensor image
}
\examples{
if (torch::torch_is_installed()) {
image_tensor <- torch::torch_randint(170, 250, size = c(3, 360, 360))$to(torch::torch_uint8())
mask <- torch::torch_tril(torch::torch_ones(c(360, 360)))$to(torch::torch_bool())
masked_image <- draw_segmentation_masks(image_tensor, mask, alpha = 0.2)
tensor_image_browse(masked_image)
}
}
\seealso{
Other image display: 
\code{\link{draw_bounding_boxes}()},
\code{\link{draw_keypoints}()},
\code{\link{tensor_image_browse}()},
\code{\link{tensor_image_display}()},
\code{\link{vision_make_grid}()}
}
\concept{image display}
