% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-vision.R
\name{nnf_grid_sample}
\alias{nnf_grid_sample}
\title{Grid_sample}
\usage{
nnf_grid_sample(
  input,
  grid,
  mode = c("bilinear", "nearest"),
  padding_mode = c("zeros", "border", "reflection"),
  align_corners = FALSE
)
}
\arguments{
\item{input}{(Tensor) input of shape \eqn{(N, C, H_{\mbox{in}}, W_{\mbox{in}})} (4-D case)                    or \eqn{(N, C, D_{\mbox{in}}, H_{\mbox{in}}, W_{\mbox{in}})} (5-D case)}

\item{grid}{(Tensor) flow-field of shape \eqn{(N, H_{\mbox{out}}, W_{\mbox{out}}, 2)} (4-D case)                   or \eqn{(N, D_{\mbox{out}}, H_{\mbox{out}}, W_{\mbox{out}}, 3)} (5-D case)}

\item{mode}{(str) interpolation mode to calculate output values \code{'bilinear'} | \code{'nearest'}.
Default: \code{'bilinear'}}

\item{padding_mode}{(str) padding mode for outside grid values \code{'zeros'} | \code{'border'}
| \code{'reflection'}. Default: \code{'zeros'}}

\item{align_corners}{(bool, optional) Geometrically, we consider the pixels of the
input  as squares rather than points. If set to \code{True}, the extrema (\code{-1} and
\code{1}) are considered as referring to the center points of the input's corner pixels.
If set to \code{False}, they are instead considered as referring to the corner
points of the input's corner pixels, making the sampling more resolution
agnostic. This option parallels the \code{align_corners} option in  \code{\link[=nnf_interpolate]{nnf_interpolate()}}, and
so whichever option is used here should also be used there to resize the input
image before grid sampling. Default: \code{False}}
}
\description{
Given an \code{input} and a flow-field \code{grid}, computes the
\code{output} using \code{input} values and pixel locations from \code{grid}.
}
\details{
Currently, only spatial (4-D) and volumetric (5-D) \code{input} are
supported.

In the spatial (4-D) case, for \code{input} with shape
\eqn{(N, C, H_{\mbox{in}}, W_{\mbox{in}})} and \code{grid} with shape
\eqn{(N, H_{\mbox{out}}, W_{\mbox{out}}, 2)}, the output will have shape
\eqn{(N, C, H_{\mbox{out}}, W_{\mbox{out}})}.

For each output location \verb{output[n, :, h, w]}, the size-2 vector
\code{grid[n, h, w]} specifies \code{input} pixel locations \code{x} and \code{y},
which are used to interpolate the output value \verb{output[n, :, h, w]}.
In the case of 5D inputs, \code{grid[n, d, h, w]} specifies the
\code{x}, \code{y}, \code{z} pixel locations for interpolating
\verb{output[n, :, d, h, w]}. \code{mode} argument specifies \code{nearest} or
\code{bilinear} interpolation method to sample the input pixels.

\code{grid} specifies the sampling pixel locations normalized by the
\code{input} spatial dimensions. Therefore, it should have most values in
the range of \verb{[-1, 1]}. For example, values \verb{x = -1, y = -1} is the
left-top pixel of \code{input}, and values  \verb{x = 1, y = 1} is the
right-bottom pixel of \code{input}.

If \code{grid} has values outside the range of \verb{[-1, 1]}, the corresponding
outputs are handled as defined by \code{padding_mode}. Options are
\itemize{
\item \code{padding_mode="zeros"}: use \code{0} for out-of-bound grid locations,
\item \code{padding_mode="border"}: use border values for out-of-bound grid locations,
\item \code{padding_mode="reflection"}: use values at locations reflected by
the border for out-of-bound grid locations. For location far away
from the border, it will keep being reflected until becoming in bound,
e.g., (normalized) pixel location \code{x = -3.5} reflects by border \code{-1}
and becomes \verb{x' = 1.5}, then reflects by border \code{1} and becomes
\verb{x'' = -0.5}.
}
}
\section{Note}{


This function is often used in conjunction with \code{\link[=nnf_affine_grid]{nnf_affine_grid()}}
to build \verb{Spatial Transformer Networks}_ .
}

