% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safety_first_index.R
\name{safety_first_index}
\alias{safety_first_index}
\title{Safety-first Index}
\usage{
safety_first_index(data, trait, genotype, environment, lambda)
}
\arguments{
\item{data}{a dataframe containing trait, genotype and environment.}

\item{trait}{colname of a column containing a numeric vector of interested trait to be analyzed.}

\item{genotype}{colname of a column containing a character or factor vector labeling different genotypic varieties.}

\item{environment}{colname of a column containing a character or factor vector labeling different environments.}

\item{lambda}{the minimal acceptable value of trait that the user expected from crop across environments. Lambda should between the ranges of trait vlaue.}
}
\value{
a data table with coefficient of determination
}
\description{
\code{safety_first_index} calculate variance of a genotype across environments.
}
\details{
Safety-first index (Eskridge, 1990) is calculated based on the assumption of
that the trait from each genotype follows normal distribution over enviornments.
Among different environments, trait below a given cirtical level \eqn{\lambda}
is defined as failure of trait. The probability of trait failure can be obtained
by entering mean and variance of trait and \eqn{\lambda}
into the cumulated density function of normal distribution.
Variety with low safety first index is considered as stable.
Equation of adjusted coefficient of variation can be found in vignette file.
}
\examples{
data(Data)
safety.first.index <- safety_first_index(
 data = Data,
 trait = "Yield",
 genotype = "Genotype",
 environment = "Environment",
 lambda = median(Data$Yield))
}
\references{
\insertRef{eskridge1990}{toolStability}
}
\author{
Tien-Cheng Wang
}
\keyword{approach}
\keyword{probabilistic}
