% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_scale_.R
\name{tm_scale_ordinal}
\alias{tm_scale_ordinal}
\alias{tm_scale_categorical}
\title{Scales: categorical and ordinal scale}
\usage{
tm_scale_ordinal(
  n.max = 30,
  values = NA,
  values.repeat = FALSE,
  values.range = 1,
  values.scale = NA,
  value.na = NA,
  value.null = NA,
  value.neutral = NA,
  levels = NULL,
  levels.drop = FALSE,
  labels = NULL,
  label.na = NA,
  label.null = NA,
  label.format = list()
)

tm_scale_categorical(
  n.max = 30,
  values = NA,
  values.repeat = TRUE,
  values.range = NA,
  values.scale = NA,
  value.na = NA,
  value.null = NA,
  value.neutral = NA,
  levels = NULL,
  levels.drop = FALSE,
  labels = NULL,
  label.na = NA,
  label.null = NA,
  label.format = list()
)
}
\arguments{
\item{n.max}{Maximum number of categories (factor levels). In case there are more, they are grouped into \code{n.max} groups.}

\item{values}{(generic scale argument) The visual values. For colors (e.g. \code{fill} or \code{col} for \code{tm_polygons()}) this is a palette name from the \code{cols4all} package (see \code{\link[cols4all:c4a]{cols4all::c4a()}}) or vector of colors, for size (e.g. \code{size} for \code{tm_symbols()}) these are a set of sizes (if two values are specified they are interpret as range), for symbol shapes (e.g. \code{shape} for \code{\link[=tm_symbols]{tm_symbols()}}) these are a set of symbols, etc. The tmap option \code{values.var} contains the default values per visual variable and in some cases also per data type.}

\item{values.repeat}{(generic scale argument) Should the values be repeated in case there are more categories?}

\item{values.range}{(generic scale argument) Range of the values. Vector of two numbers (both between 0 and 1) where the first determines the minimum and the second the maximum. Full range, which means that all values are used, is encoded as \code{c(0, 1)}. For instance, when a gray scale is used for color (from black to white), \code{c(0,1)} means that all colors are used, \verb{0.25, 0.75} means that only colors from dark gray to light gray are used (more precisely \code{"grey25"} to \code{"grey75"}), and \verb{0, 0.5} means that only colors are used from black to middle gray (\code{"gray50"}). When only one number is specified, this is interpreted as the second number (where the first is set to 0). Default values can be set via the tmap option \code{values.range}.}

\item{values.scale}{(generic scale argument) Scaling of the values. Only useful for size-related visual variables, such as \code{size} of \code{\link[=tm_symbols]{tm_symbols()}} and \code{lwd} of \code{\link[=tm_lines]{tm_lines()}}.}

\item{value.na}{(generic scale argument) Value used for missing values. See tmap option \code{"value.na"} for defaults per visual variable.}

\item{value.null}{(generic scale argument) Value used for NULL values. See tmap option \code{"value.null"} for defaults per visual variable. Null data values occur when out-of-scope features are shown (e.g. for a map of Europe showing a data variable per country, the null values are applied to countries outside Europe).}

\item{value.neutral}{(generic scale argument) Value that can be considered neutral. This is used for legends of other visual variables of the same map layer. E.g. when both \code{fill} and \code{size} are used for \code{\link[=tm_symbols]{tm_symbols()}} (using filled circles), the size legend items are filled with the \code{value.neutral} color from the \code{fill.scale} scale, and fill legend items are bubbles of size \code{value.neutral} from the \code{size.scale} scale.}

\item{levels}{Levels to show. Other values are treated as missing.}

\item{levels.drop}{Should unused levels be dropped (and therefore are not assigned to a visual value and shown in the legend)?}

\item{labels}{(generic scale argument) Labels}

\item{label.na}{(generic scale argument) Label for missing values}

\item{label.null}{(generic scale argument) Label for null (out-of-scope) values}

\item{label.format}{(generic scale argument) Label formatting. Output of \code{\link[=tm_label_format]{tm_label_format()}}}
}
\description{
Scales in tmap are configured by the family of functions with prefix \code{tm_scale}.
Such function should be used for the input of the \code{.scale} arguments in the
layer functions (e.g. \code{fill.scale} in \code{\link[=tm_polygons]{tm_polygons()}}).
The functions \code{tm_scale_categorical()} and \code{tm_scale_ordinal()} are used
for categorical data. The only difference between these functions is that the
former assumes unordered categories whereas the latter assumes ordered categories.
For colors (the visual variable \code{fill} or \code{col}), different default color
palettes are used (see the tmap option \code{values.var}).
}
\seealso{
\code{\link[=tm_scale]{tm_scale()}}
}
