% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeJUnit.R
\name{writeJUnit}
\alias{writeJUnit}
\title{Write the results of a \code{tinytests}-object into JUnit xml report.}
\usage{
writeJUnit(tinytests, file = stdout(), overwrite = TRUE)
}
\arguments{
\item{tinytests}{\code{tinytests}-object to convert to JUnit xml.}

\item{file}{\code{character(1) | connection}: Full file path or connection object to write the
JUnit xml content to. By default \code{stdout()} connection is used.}

\item{overwrite}{\code{logical(1)}: should the file be overwritten if it already exist?
By default TRUE.}
}
\value{
\code{invisible(TRUE)} Might get another use in the future.
}
\description{
Write the \code{tinytests}-object to a JUnit XML reporting file. If a \code{tinytests2JUnit} is provided
(returned by \code{\link[=runTestDir]{runTestDir()}}) more info will get reported.
}
\section{Errors}{

In case of overwrite = FALSE and the file already exists an error is thrown.
}

\section{Side-effects}{

Side effects are registered as 'passed' tests in the JUnit output and have been given a status
"SIDE-EFFECT". The call and diff is also returned in the standard-output of the testcase tag.

They are not considred failures and would thus not stop a pipeline.
}

\section{tinytests to JUnit}{


To comply the the JUnit specification the tests results are adapted as follows:
\itemize{
\item A single test run \code{tinytests} is mapped to a \verb{<testsuites>} tag.
\item All \code{tinytest} results from a single file are mapped to a single \verb{<testsuite>} tag.
\itemize{
\item The name of the testsuite is equal to the test file name (without the file suffix)
}
\item An individual \code{tinytest} object (eg. a single \verb{except_*} exception test) is mapped to a
\verb{<testcase>} tag.
\itemize{
\item The name of the testcase is equal to the fileName + Line specification of where the expect
statement is performed + the info.
}
}

For reference: \url{https://llg.cubic.org/docs/junit/}
}

\examples{
# Run tests with `tinytest`
dirWithTests <- system.file("example_tests/multiple_files",package = "tinytest2JUnit")
testresults <- runTestDir(dirWithTests)

writeJUnit(testresults) # Writes content to stdout

tmpFile <- tempfile(fileext = ".xml")
writeJUnit(tinytests = testresults, file = tmpFile)
}
\seealso{
The JUnit XML report format:  \url{https://llg.cubic.org/docs/junit/}
}
