% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source-decoratees.R
\name{source_decoratees}
\alias{source_decoratees}
\title{Read and Parse Decoratees from a File}
\usage{
source_decoratees(file)
}
\arguments{
\item{file}{A character string specifying a file path.}
}
\description{
Given a file, \code{source_decoratees} reads and parses decorated functions
(decoratees) into the calling environment.
}
\details{
Malformed decoratees are ignored and a message will alert the user a function
has been skipped. However, an error is raised if a decorator is undefined.

If you are working within RStudio the "Source Active File Decoratees" addin
effectively allows you to bind \code{source_decoratees} to a keyboard
shorcut. The addin is found under \bold{Tools} > \bold{Addins}.
}
\examples{
# source example files
source_decoratees(tinsel_example('attributes.R'))
source_decoratees(tinsel_example('tags.R'))

# the important thing is to look at the contents
# of the example files, note the use of the special
# "#." comment
writeLines(readLines(tinsel_example('attributes.R')))
writeLines(readLines(tinsel_example('tags.R')))

# the decorator functions are not sourced,
exists('attribute')  # FALSE
exists('html_wrap')  # FALSE

# only decorated functions are sourced
print(selector1)
selector1(mtcars, 'mpg')

# format with bold tags
html_bold('make this bold')

# format with paragraph tags
html_paragraph("I'll make my report as if I told a story...")

}

