% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{db_dataset_list}
\alias{db_dataset_list}
\title{Get All Available Datasets and Their Description}
\usage{
db_dataset_list(con, schema = "timeseries")
}
\arguments{
\item{con}{RPostgres connection object.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
data.frame with columns `set_id` and `set_description`
}
\description{
Get All Available Datasets and Their Description
}
\examples{

\dontrun{

db_dataset_create(
  con = connection,
  set_name = "zrh_airport_data",
  set_description = "Zurich airport arrivals and departures ",
  schema = "schema"
)

db_dataset_list(
  con = connection,
  schema = "schema"
)
}
}
\seealso{
Other datasets functions: 
\code{\link{db_dataset_create}()},
\code{\link{db_dataset_delete}()},
\code{\link{db_dataset_get_keys}()},
\code{\link{db_dataset_get_last_update}()},
\code{\link{db_dataset_trim_history}()},
\code{\link{db_dataset_update_metadata}()},
\code{\link{db_ts_assign_dataset}()},
\code{\link{db_ts_get_dataset}()}
}
\concept{datasets functions}
