% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNIPAFiles.R
\name{getNIPAFiles}
\alias{getNIPAFiles}
\title{Download and Process BEA NIPA Files with Fast Row Expansion}
\usage{
getNIPAFiles(
  location = "https://apps.bea.gov/national/Release/TXT/",
  type = "Q"
)
}
\arguments{
\item{location}{The URL or path where the BEA files are located.
Default: "https://apps.bea.gov/national/Release/TXT/".}

\item{type}{A character string indicating the type of data to load.
For example, "Q" for quarterly or "M" for monthly data. Default is "Q".}
}
\value{
A data frame containing the merged and formatted NIPA data.
}
\description{
This function downloads and processes National Income and Product Accounts (NIPA)
data files from the BEA website. It reads the necessary register files, formats the
date column, and then uses the fast stringi functions together with tidyr's unnest()
to split the combined \code{TableId:LineNo} field into separate rows and columns. Finally,
it merges the datasets.
}
\examples{
\donttest{
  nipadata <- getNIPAFiles(type = "Q")
}

}
