% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{constraints}
\alias{constraints}
\title{Create a constraints object}
\usage{
constraints(
  schema,
  constraints_df_num = NULL,
  constraints_df_cat = NULL,
  max_z_num = 0,
  max_z_cat = 0
)
}
\arguments{
\item{schema}{A \code{schema} object}

\item{constraints_df_num}{A specially formatted data frame with constraints
to be imposed during the synthesis process. See examples for formatting.}

\item{constraints_df_cat}{A specifically formatted data frame with constraints
to be imposed during the synthesis process.}

\item{max_z_num}{Numeric vector(s) for the number of times a value should be
resampled before hardbounding if it violates a constraint.}

\item{max_z_cat}{Numeric vector(s) for the number of times a value should be
resampled before hardbounding if it violates a constraint.}
}
\value{
A \code{constraints} object.
}
\description{
Create a constraints object
}
\examples{

constraints(
  schema = schema(
    conf_data = mtcars |> dplyr::mutate(vs = factor(vs)),
    start_data = dplyr::select(mtcars, cyl)
  ),
  constraints_df_num = tibble::tribble(
    ~var, ~min, ~max, ~conditions, 
    # ensure all mpg values are greater than 0
    "mpg", 0, Inf, "TRUE",
    # ensure when cyl == 6, mpg is less than 15
    "mpg", -Inf, 15, "cyl == 6",
    # ensure disp is always between 0 and 150
    "disp", 0, 150, "TRUE"
  ),
  constraints_df_cat = tibble::tribble(
    ~var, ~allowed, ~forbidden, ~conditions, 
    # ensure vs != 1 when gear >= 4
    "vs", NA,  1, "gear >= 5",
    # ensure vs == 1 when gear >= 4
    "vs", 0,  NA, "gear == 4"
  )
)

}
