% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_sequence_api.R
\name{add_sequence_factor}
\alias{add_sequence_factor}
\title{Add to visit sequence for factor variables}
\usage{
add_sequence_factor(roadmap, ..., method = c("entropy", "gini"))
}
\arguments{
\item{roadmap}{A \code{roadmap} object}

\item{...}{\verb{<tidy-select>} One or more unquoted expressions separated by
commas. Variable names can be used as if they were positions in the data
frame, so expressions like x:y can be used to select a range of variables.}

\item{method}{A quoted name for the method used to sort the visit_sequence.
Current methods include "entropy" and "gini".}
}
\value{
An updated visit_sequence
}
\description{
Add to visit sequence for factor variables
}
\examples{

roadmap(
  conf_data = acs_conf_nw, 
  start_data = acs_start_nw
) |>
  add_sequence_factor(dplyr::where(is.factor), method = "gini")

}
