% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_sq.R
\name{import_sq}
\alias{import_sq}
\title{Import sq objects from other objects}
\usage{
import_sq(object, ...)
}
\arguments{
\item{object}{[\code{any(1)}]\cr
An object of one of supported classes.}

\item{...}{further arguments to be passed from or to other methods.}
}
\value{
A \code{\link[tibble]{tibble}} with \code{sq} column of
\code{\link[=sq-class]{sq}} type representing the same sequences as given
object; the object has a type corresponding to the input type; if given
sequences have names, output \code{\link[tibble]{tibble}} will also have
another column \code{name} with those names
}
\description{
Creates \code{\link[=sq-class]{sq}} object from object of class
from another package. Currently supported packages are \pkg{ape},
\pkg{bioseq}, \pkg{Bioconductor} and \pkg{seqinr}. For exact list of
supported classes and resulting types, see details.
}
\details{
Currently supported classes are as follows:
\itemize{
\item \code{ape}:
 \itemize{
 \item \code{AAbin} - imported as \strong{ami_bsc}
 \item \code{DNAbin} - imported as \strong{dna_bsc}
 \item \code{alignment} - exact type is guessed within \code{\link{sq}}
  function
 }
\item \code{bioseq}:
 \itemize{
 \item \code{bioseq_aa} - imported as \strong{ami_ext}
 \item \code{bioseq_dna} - imported as \strong{dna_ext}
 \item \code{bioseq_rna} - imported as \strong{rna_ext}
 }
\item \code{Biostrings}:
 \itemize{
 \item \code{AAString} - imported as \strong{ami_ext} with exactly one
  sequence
 \item \code{AAStringSet} - imported as \strong{ami_ext}
 \item \code{DNAString} - imported as \strong{dna_ext} with exactly one
  sequence
 \item \code{DNAStringSet} - imported as \strong{dna_ext}
 \item \code{RNAString} - imported as \strong{rna_ext} with exactly one
  sequence
 \item \code{RNAStringSet} - imported as \strong{rna_ext}
 \item \code{BString} - imported as \strong{unt} with exactly one
  sequence
 \item \code{BStringSet} - imported as \strong{unt}
 \item \code{XStringSetList} - each element of a list can be imported as
  a separate \code{\link[tibble]{tibble}}, resulting in a list of tibbles;
  if passed argument \code{separate = FALSE}, these tibbles are bound into
  one bigger tibble
 }
\item \code{seqinr}:
 \itemize{
 \item \code{SeqFastaAA} - imported as \strong{ami_bsc}
 \item \code{SeqFastadna} - imported as \strong{dna_bsc}
 }
}

Providing object of class other than specified will result in an error.
}
\examples{
\dontshow{if (require("ape", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# ape example
library(ape)
ape_dna <- as.DNAbin(list(one = c("C", "T", "C", "A"), two = c("T", "G", "A", "G", "G")))
import_sq(ape_dna)
\dontshow{\}) # examplesIf}
\dontshow{if (require("bioseq", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# bioseq example
library(bioseq)
bioseq_rna <- new_rna(c(one = "ANBRY", two = "YUTUGGN"))
import_sq(bioseq_rna)
\dontshow{\}) # examplesIf}
\dontshow{if (require("Biostrings", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Biostrings example
library(Biostrings)
Biostrings_ami <- AAStringSet(c(one = "FEAPQLIWY", two = "EGITENAK"))
import_sq(Biostrings_ami)
\dontshow{\}) # examplesIf}
\dontshow{if (require("seqinr", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# seqinr example
library(seqinr)
seqinr_dna <- as.SeqFastadna(c("C", "T", "C", "A"), name = "one")
import_sq(seqinr_dna)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=sq-class]{sq class}}

Functions from input module:
\code{\link{random_sq}()},
\code{\link{read_fasta}()},
\code{\link{sq}()}
}
\concept{input_functions}
