% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_test.R
\name{lm_test}
\alias{lm_test}
\title{Linear Model Testing for Grouped, Nested, or Ungrouped Data}
\usage{
lm_test(input_data, formula)
}
\arguments{
\item{input_data}{A data frame or tibble. Can be ungrouped, grouped, or nested.}

\item{formula}{A model formula, either quoted or unquoted (e.g., y ~ x * z , or "y ~ x * z").}
}
\value{
A tibble with tidy model output sorted by p value, including:
\describe{
  \item{term}{Model term (e.g., intercept, predictors, interactions)}
  \item{estimate}{Estimated coefficient / beta}
  \item{std.error}{Standard error of the estimate}
  \item{statistic}{t-statistic}
  \item{p.value}{p-value for the hypothesis test}
}
If the input is grouped or nested, group identifiers are retained in the output.
In the nested case, nested terms are relocated to the left-most column of the tibble.
}
\description{
Applies a linear model to a data frame and returns tidy model summaries.
Supports ungrouped, grouped (dplyr::group_by()), and nested (tidyr::nest_by()) input data.
}
\details{
Designed to allow seamless 'in-line' chaining to fit linear models to columns of a tibble. Compatible with ungrouped, grouped or nested input. Compatible with native and magrittr pipe.
Uses broom::tidy() to extract model summaries.
}
\examples{
library(ggplot2)
library(dplyr)

# Ungrouped
mpg |> lm_test( cty ~ hwy * cyl)

# Grouped
mpg |> group_by(class) |> lm_test(cty ~ hwy * cyl)

# Nested
mpg  |> nest_by(class) |> lm_test(cty ~ hwy * cyl)

}
