% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_adj_indirect.R
\name{rate_adj_indirect}
\alias{rate_adj_indirect}
\title{Compute direct adjusted rates with tibbles}
\usage{
rate_adj_indirect(
  .data,
  .std,
  .keys = NULL,
  .name_var = "name",
  .value_var = "value",
  .age_group_var = "age_group",
  .age_group_pop_var = "population",
  .events_label = "events",
  .population_label = "population",
  .progress = TRUE
)
}
\arguments{
\item{.data}{A tibble containing events counts and population per groups (e.g. age groups)}

\item{.std}{A vector with standard population values for each group}

\item{.keys}{Optional. A character vector with grouping variables, like year and region code.}

\item{.name_var}{Variable containing variable names. Defaults to \code{name}.}

\item{.value_var}{Variable containing values. Defaults to \code{value}.}

\item{.age_group_var}{Variable name of age groups. Defaults to \code{age_group}.}

\item{.age_group_pop_var}{Variable name of population size on \code{.std}. Defaults to \code{population}.}

\item{.events_label}{Label used for events at the \code{name_var} variable. Defaults to \code{events}.}

\item{.population_label}{Label used for population at the \code{name_var} variable. Defautls to \code{population}.}

\item{.progress}{Whether to show a progress bar. Defaults to \code{TRUE}.}
}
\value{
A tibble with crude and adjusted rate, lower and upper confidence intervals.
}
\description{
Computes indirect adjusted rates and confidence intervals.
}
\details{
This functions wraps the \code{epitools} \link[epitools]{ageadjust.indirect} function to compute indirect adjusted rates and "exact" confidence intervals using \code{tibble} objects with multiple grouping keys.

A tibble (\code{.data}) must be informed containing key variables like year and region code, and population and and events count (e.g. cases) per age group. Check the \code{fleiss_data} for an example.

A tibble (\code{.std}) must be also supplied containing the age groups, events and population size. By default, this tibble has three variables, named \code{age_group}, \code{name} and \code{value}. Check the \code{selvin_data_1940} for an example.
}
\examples{
rate_adj_indirect(.data = selvin_data_1960, .std = selvin_data_1940)
}
