% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_voyage.R
\name{voyage_embedding}
\alias{voyage_embedding}
\title{Generate Embeddings Using Voyage AI API}
\usage{
voyage_embedding(
  .input,
  .model = "voyage-3",
  .timeout = 120,
  .dry_run = FALSE,
  .max_tries = 3,
  .verbose = FALSE
)
}
\arguments{
\item{.input}{Input to embed. Can be:
\itemize{
\item A character vector of texts
\item An \code{LLMMessage} object (all textual components will be embedded)
\item A list containing a mix of character strings and \code{tidyllm_image} objects created with \code{img()}
}}

\item{.model}{The embedding model identifier. For text-only: "voyage-3" (default).
For multimodal inputs: "voyage-multimodal-3" is used automatically.}

\item{.timeout}{Timeout for the API request in seconds (default: 120).}

\item{.dry_run}{If TRUE, perform a dry run and return the request object without sending.}

\item{.max_tries}{Maximum retry attempts for requests (default: 3).}

\item{.verbose}{Should information about current rate limits be printed? (default: FALSE).}
}
\value{
A tibble with two columns: \code{input} and \code{embeddings}.
\itemize{
\item The \code{input} column contains the input texts or image labels
\item The \code{embeddings} column is a list column where each row contains an embedding vector
}
}
\description{
This function creates embedding vectors from text or multimodal inputs (text and images)
using the Voyage AI API. It supports three types of input:
}
\details{
\enumerate{
\item Character vector: Embeds each text string separately
\item LLMMessage object: Extracts and embeds text content from messages
\item List of mixed content: Processes a combination of text strings and image objects created with \code{img()}
}

For multimodal inputs, the function automatically switches to Voyage's multimodal API
and formats the response with appropriate labels (e.g., \code{"[IMG] image.png"}) for images.
}
\examples{
\dontrun{
# Text embeddings
voyage_embedding("How does photosynthesis work?")

# Multimodal embeddings
list("A banana", img("banana.jpg"), "Yellow fruit") |>
  voyage_embedding()
}
}
