% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{methods.dfidx}
\alias{methods.dfidx}
\alias{print.tbl_dfidx}
\alias{vec_ptype_abbr.vecidx}
\alias{format.vecidx}
\alias{pillar_shaft.vecidx}
\alias{tbl_sum.tbl_dfidx2}
\title{Methods for dfidx}
\usage{
\method{print}{tbl_dfidx}(x, ..., n = NULL)

\method{vec_ptype_abbr}{vecidx}(x, ..., prefix_named, suffix_shape)

\method{format}{vecidx}(x, ...)

\method{pillar_shaft}{vecidx}(x, ...)

\method{tbl_sum}{tbl_dfidx2}(x, ...)
}
\arguments{
\item{x}{a \code{dfidx} object}

\item{...}{further arguments}

\item{n}{the number of rows for the print method}

\item{prefix_named, suffix_shape}{see \link[vctrs:vec_ptype_full]{vctrs::vec_ptype_abbr}}
}
\value{
\code{as.data.frame} and \code{mean} return a \code{data.frame}, \code{[[} and
\code{$} a vector, \code{[} either a \code{dfidx} or a vector, \verb{$<-}
and \verb{[[<-} modify the values of an existing column or create a
new column of a \code{dfidx} object, \code{print} is called for its side
effect
}
\description{
A \code{dfidx} is a \code{data.frame} with a "sticky" data.frame column
which contains the indexes. Specific methods of functions that
extract lines and/or columns of a \code{data.frame} are provided.
}
\examples{
data("munnell", package = "dfidx")
mn <- dfidx(munnell)
# extract a series (returns as a xseries object)
mn$gsp
# or
mn[["gsp"]]
# extract a subset of series (returns as a dfidx object)
mn[c("gsp", "unemp")]
# extract a subset of rows and columns
mn[mn$unemp > 10, c("utilities", "water")]
# dfidx, idx and xseries have print methods as (like tibbles), a n
# argument
print(mn, n = 3)
print(idx(mn), n = 3)
print(mn$gsp, n = 3)
# a dfidx object can be coerced to a data.frame
head(as.data.frame(mn))
}
\author{
Yves Croissant
}
