% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R, R/class-seg_cpt.R,
%   R/pkg-GA.R, R/pkg-changepoint.R, R/pkg-changepointGA.R, R/pkg-segmented.R,
%   R/pkg-strucchange.R, R/pkg-wbs.R
\name{seg_params}
\alias{seg_params}
\alias{seg_params.seg_cpt}
\alias{seg_params.ga}
\alias{seg_params.cpt}
\alias{seg_params.cptga}
\alias{seg_params.lm}
\alias{seg_params.breakpointsfull}
\alias{seg_params.wbs}
\title{Retrieve parameters from a segmenter}
\usage{
seg_params(object, ...)

\method{seg_params}{seg_cpt}(object, ...)

\method{seg_params}{ga}(object, ...)

\method{seg_params}{cpt}(object, ...)

\method{seg_params}{cptga}(object, ...)

\method{seg_params}{lm}(object, ...)

\method{seg_params}{breakpointsfull}(object, ...)

\method{seg_params}{wbs}(object, ...)
}
\arguments{
\item{object}{A \code{segmenter} object.}

\item{...}{currently ignored}
}
\value{
A named \code{list} of parameters with their values.
}
\description{
Retrieve parameters from a segmenter
}
\details{
Most segmenting algorithms have parameters.
This function retrieves an informative set of those parameter values.
}
\examples{
# Segment a time series using PELT
x <- segment(CET, method = "pelt")
x |>
  as.segmenter() |>
  seg_params()

}
\seealso{
Other segmenter-functions: 
\code{\link{as.segmenter}()},
\code{\link{fitness}()},
\code{\link{model_args}()}
}
\concept{segmenter-functions}
