% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{binary2tau}
\alias{binary2tau}
\alias{tau2binary}
\title{Convert changepoint sets to binary strings}
\usage{
binary2tau(x)

tau2binary(tau, n)
}
\arguments{
\item{x}{A binary string that encodes a changepoint set. See
\code{\link[GA:ga_Population]{GA::gabin_Population()}}.}

\item{tau}{a numeric vector of changepoint indices}

\item{n}{the length of the original time series}
}
\value{
\itemize{
\item \code{\link[=binary2tau]{binary2tau()}}: an \code{integer} vector
}

\itemize{
\item \code{\link[=tau2binary]{tau2binary()}}: an \code{integer} vector of length \code{n}
}
}
\description{
Convert changepoint sets to binary strings
}
\details{
In order to use \code{\link[GA:ga]{GA::ga()}} in a genetic algorithm, we need to encoude a
changepoint set as a binary string.

\code{\link[=binary2tau]{binary2tau()}} takes a binary string representation of a changepoint set and
converts it into a set of changepoint indices.

\code{\link[=tau2binary]{tau2binary()}} takes a set of changepoint indices the number of observations
in the time series and converts them into a binary string representation of
that changepoint set.
}
\examples{
# Recover changepoint set indices from binary strings
binary2tau(c(0, 0, 1, 0, 1))
binary2tau(round(runif(10)))

# Recover binary strings from changepoint set indices
tau2binary(c(7, 17), n = 24)
tau2binary(binary2tau(c(0, 0, 1, 1, 0, 1)), n = 6)

}
