% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{censuskor}
\alias{censuskor}
\title{South Korea Census Data}
\format{
A data.frame with 67232 rows and 10 variables:
}
\source{
\itemize{
\item KOSIS (Korean Statistical Information Service)
}
}
\usage{
censuskor
}
\description{
District level data including tax, population, business entities,
housing, economy, medicine
and mortality in South Korea in 2010, 2015, and/or 2020. The availble
years and variables depend on the type of data.
}
\details{
\itemize{
\item year Year of the census data, e.g., 2010, 2015, or 2020
\item adm1 Name of the province-level (Sido) administrative unit
\item adm1_code Code of the province-level (Sido) administrative unit
\item adm2 Name of the district/municipal-level (Sigungu) administrative unit
\item adm2_code  Code of the district/municipal-level (Sigungu) administrative unit
\item type Type of variable,
e.g., "population", "tax", "mortality", "housing", "medicine", "migration", "environment", "welfare", or "economy"
\item class1 First-level classification of the variable depending on the type
\item class2 Second-level classification of the variable depending on the type
\item unit Unit of measurement for the variable
\item value  Value of the variable
}
}
\note{
NA values in the value field indicate that the data was omitted
or suppressed. We kept these NA values as-is to reflect the
original data from the source.
For temporal comparison, province names in adm1 field are
standardized to the common names with no suffix in metropolitan cities
and "-do" suffix in provinces.
For example, "Seoul" instead of "Seoul Metropolitan City",
and "Jeollabuk-do" instead of "Jeonbuk State".
"KRW" in the unit field stands for South Korean Won.
Values are as-is unless otherwise noted in the unit field
(e.g., "per 100k population" or "million KRW").
}
\keyword{datasets}
