% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_non_numeric_cols.R
\name{select_non_numeric_cols}
\alias{select_non_numeric_cols}
\title{Select Non-Numeric Columns}
\usage{
select_non_numeric_cols(dataset, remove_na = FALSE)
}
\arguments{
\item{dataset}{A vector, matrix, data frame, or tibble.}

\item{remove_na}{Logical. If TRUE, rows with any NA values will be dropped. Default is FALSE.}
}
\value{
A tibble with only non-numeric columns.
}
\description{
Returns a tibble with only the non-numeric columns of the input, and optionally drops rows with NAs.
}
\examples{
select_non_numeric_cols(iris)

df <- tibble::tibble(a = 1:6, b = c("x", "y", NA, NA, "z", NA))
select_non_numeric_cols(df, remove_na = TRUE)
}
