#' Simulated identity data
#'
#' This simulated dataset, based on Crochetti et al., 2014, contains five annual
#' assessments of adolescents' mean scores on the commitment, exploration (in
#' depth), and reconsideration subscales of the Utrecht-Management of Identity
#' Commitments Scale (Crocetti et al., 2008). The scores reported here reflect
#' the educational identity subscales of this instrument. The first measurement
#' wave occurred when adolescents were, on
#' average, 14 years old, and the last one when they were 18 years old.
#'
#' \tabular{lll}{
#'   \strong{com1} \tab \code{numeric} \tab Mean score
#'   of educational commitment in
#'   wave 1\cr
#'   \strong{exp1} \tab \code{numeric} \tab Mean score
#'   of educational exploration in
#'   wave 1\cr
#'   \strong{rec1} \tab \code{numeric} \tab Mean score
#'   of educational reconsideration in
#'   wave 1\cr
#'   \strong{com2} \tab \code{numeric} \tab Mean score
#'   of educational commitment in
#'   wave 2\cr
#'   \strong{exp2} \tab \code{numeric} \tab Mean score
#'   of educational exploration in
#'   wave 2\cr
#'   \strong{rec2} \tab \code{numeric} \tab Mean score
#'   of educational reconsideration in
#'   wave 2\cr
#'   \strong{com3} \tab \code{numeric} \tab Mean score
#'   of educational commitment in
#'   wave 3\cr
#'   \strong{exp3} \tab \code{numeric} \tab Mean score
#'   of educational exploration in
#'   wave 3\cr
#'   \strong{rec3} \tab \code{numeric} \tab Mean score
#'   of educational reconsideration in
#'   wave 3\cr
#'   \strong{com4} \tab \code{numeric} \tab Mean score
#'   of educational commitment in
#'   wave 4\cr
#'   \strong{exp4} \tab \code{numeric} \tab Mean score
#'   of educational exploration in
#'   wave 4\cr
#'   \strong{rec4} \tab \code{numeric} \tab Mean score
#'   of educational reconsideration in
#'   wave 4\cr
#'   \strong{com5} \tab \code{numeric} \tab Mean score
#'   of educational commitment in
#'   wave 5\cr
#'   \strong{exp5} \tab \code{numeric} \tab Mean score
#'   of educational exploration in
#'   wave 5\cr
#'   \strong{rec5} \tab \code{numeric} \tab Mean score
#'   of educational reconsideration in
#'   wave 5\cr
#'   \strong{sex} \tab \code{factor} \tab Adolescent sex; M = male, F = female.
#' }
#' @docType data
#' @keywords datasets
#' @name id_edu
#' @usage data(id_edu)
#' @references Crocetti, E., Klimstra, T. A., Hale, W. W., Koot, H. M., &
#' Meeus, W. (2013). Impact of early adolescent externalizing problem behaviors
#' on identity development in middle to late adolescence: A prospective 7-year
#' longitudinal study. Journal of Youth and Adolescence, 42(11), 1745-1758.
#' \doi{10.1007/s10964-013-9924-6}
#' @format A data frame with 443 rows and 16 variables.
NULL
