% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttpeak.R
\name{ttpeak}
\alias{ttpeak}
\title{Return time to peak from time-intensity data}
\usage{
ttpeak(
  data,
  timevar,
  intensityvar,
  loess.span = 0.1,
  peakproportion = NULL,
  plotresult = FALSE,
  ...
)
}
\arguments{
\item{data}{A dataframe with time and intensity values as columns.}

\item{timevar}{A character string (in quotes) with the dataframe column name for the time variable.}

\item{intensityvar}{A character string (in quotes) with dataframe column name for the intensity variable.}

\item{loess.span}{A number between 0 and 1, with larger values resulting in a smoother curve.}

\item{peakproportion}{A number between 0 and 1 which is used in the time to peak proportion calculations. If
a number is entered the function will return the time to peak proportion.}

\item{plotresult}{TRUE or FALSE to determine whether a plot of the results is generated.}

\item{...}{Additional arguments to be passed into the loess() function.}
}
\value{
The time at which the loess curve is at its peak. Depending on the plotresult argument can also
return a plot of the smoothed curve.
}
\description{
This function returns the time to peak from time-intensity curve data. Raw data
is smoothed using a loess smoother, and the time of peak is returned. Time to a
specified proportion of the peak (e.g. time to 90\% of peak) can be calculated.
It is recommended that plotresult is set to TRUE in the first instance to visually
confirm the analysis.
}
\examples{

# Example usage: Please see package vignettes on CRAN

}
