% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-helpers.R
\name{set_block}
\alias{set_block}
\alias{empty_block}
\title{Prepare blocks of items}
\usage{
set_block(items, traits, names = items, signs = 1)

empty_block()
}
\arguments{
\item{items}{Names of item comparisons to be combined
into one block. Should correspond to variables in the data.}

\item{traits}{Names of the traits to which each item belongs}

\item{names}{Optional names of the items in the output.
Can be used to equate parameters of items across blocks,
if the same item was used in different blocks.}

\item{signs}{Expected signs of the item loadings (1 or -1).}
}
\description{
Prepare blocks of items and incorporate information
about which item belongs to which trait. A block
of items is a set of two or more items presented and answered together
by fully ranking them or selecting the most and/or least favorit
in a forced choice format. A whole test usually contains
several blocks and items may reappear in different blocks.
}
\examples{
set_block(
  items = c("i1", "i2", "i3"),
  traits = c("A", "B", "C")
) +
set_block(
  items = c("i4", "i5", "i6"),
  traits = c("A", "B", "C")
)

# Support items i1 and i4 were the same so that they have the same parameters
set_block(
  items = c("i1", "i2", "i3"),
  traits = c("A", "B", "C"),
  names = c("item1", "item2", "item3")
) +
set_block(
  items = c("i4", "i5", "i6"),
  traits = c("A", "B", "C"),
  names = c("item1", "item5", "item6")
)

}
\seealso{
\code{\link{set_blocks_from_df}}
}
