% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specific-df.R
\name{tsg_specific_df}
\alias{tsg_specific_df}
\title{Get specific datasets}
\usage{
tsg_specific_df(x, verbose = TRUE, timeout = 30, retries = 0)
}
\arguments{
\item{x}{All or a subset of a tibble returned by
\code{\link[=tsg_available]{tsg_available()}} or \code{\link[=tsg_missing]{tsg_missing()}}}

\item{verbose}{If \code{TRUE}, prints console messages on data retrieval progress.
Defaults to \code{TRUE}.}

\item{timeout}{The maximum request time, in seconds. If data is not returned
in this time, a value of \code{NA} is returned for that dataset.
Defaults to 30 seconds.}

\item{retries}{The number of retries to make if a request is not successful.
Defaults to 0.}
}
\value{
A list of tibbles with grant data.
}
\description{
Retrieve data contained with all or specific rows of a tibble
returned by \code{\link[=tsg_available]{tsg_available()}} or \code{\link[=tsg_missing]{tsg_missing()}}.
}
\examples{
\dontrun{
all_grants <- tsg_all_grants()

missing_grants <- tsg_missing(all_grants)

more_grants <- tsg_specific_df(missing_grants)
}

}
\seealso{
\code{\link[=tsg_search_grants]{tsg_search_grants()}}

\code{\link[=tsg_available]{tsg_available()}}

\code{\link[=tsg_missing]{tsg_missing()}}
}
