% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_brainatlas.R
\name{voxel_cube}
\alias{voxel_cube}
\alias{add_voxel_cube}
\alias{add_nifti}
\alias{create_voxel_cube}
\title{Generate volume data from 'MNI' coordinates}
\usage{
add_voxel_cube(
  brain,
  name,
  cube,
  size = c(256, 256, 256),
  trans_mat = NULL,
  trans_space_from = c("model", "scannerRAS"),
  color_format = c("RGBAFormat", "RedFormat")
)

add_nifti(
  brain,
  name,
  path,
  trans_mat = NULL,
  color_format = c("RGBAFormat", "RedFormat"),
  trans_space_from = c("model", "scannerRAS")
)

create_voxel_cube(
  mni_ras,
  value,
  colormap,
  keys = colormap$get_key(value),
  dimension = c(256, 256, 256)
)
}
\arguments{
\item{brain}{a 'threeBrain' brain object generated from \code{\link{freesurfer_brain2}} or \code{\link{merge_brain}}. If you have \code{'rave'} package installed, the brain can be generated from \code{rave::rave_brain2}}

\item{name}{the name of voxel cube, only letters, digits and \code{'_'} are allowed; other characters will be replaced by \code{'_'}}

\item{cube}{a 3-mode array; see the following example}

\item{size}{the actual size of the volume, usually dot multiplication of the dimension and voxel size}

\item{trans_mat}{the transform matrix of the volume. For \code{add_voxel_cube}, this matrix should be from data cube geometry model center to world (\code{'tkrRAS'}) transform. For \code{add_nifti}, this matrix is the 'Nifti' \code{'RAS'} to world (\code{'tkrRAS'}) transform.}

\item{trans_space_from}{where does \code{trans_mat} transform begin; default is from object \code{'model'} space; alternative space is \code{'scannerRAS'}, meaning the matrix only transform volume cube from its own \code{'scannerRAS'} to the world space.}

\item{color_format}{color format for the internal texture. Default is 4-channel \code{'RGBAFormat'}; alternative choice is \code{'RedFormat'}, which saves volume data with single red-channel to save space}

\item{path}{'Nifti' data path}

\item{mni_ras}{'MNI' 'RAS' coordinates, should be a \code{n}-by-3 matrix}

\item{value}{data values (length \code{n}); used if \code{keys} is missing}

\item{colormap}{a color map generated from \code{create_colormap}; see \code{\link{voxel_colormap}} for details}

\item{keys}{integer color-keys generated from a color map with length of \code{n}; alternatively, you could specify \code{value} and \code{colormap} to generate keys automatically}

\item{dimension}{volume dimension; default is a \code{256 x 256 x 256} array cube; must be integers and have length of 3}
}
\value{
\code{create_voxel_cube} returns a list of cube data and other informations;
\code{add_voxel_cube} returns the \code{brain} object
}
\description{
Generate volume data from 'MNI' coordinates
}
\examples{

# requires N27 brain to be installed
# use `download_N27()` to download template Collins brain


# sample MNI coords
tbl <- read.csv(system.file(
  'sample_data/example_cube.csv', package = 'threeBrain'
))
head(tbl)

# load colormap
cmap <- load_colormap(system.file(
  'palettes/datacube2/Mixed.json', package = 'threeBrain'
))

x <- create_voxel_cube(
  mni_ras = tbl[, c('x', 'y', 'z')],
  keys = tbl$key,
  dimension = c(128, 128, 128)
)


n27_path <- file.path(default_template_directory(), "N27")
if( interactive() && dir.exists(n27_path) ) {
  brain <- merge_brain()

  # or add_voxel_cube(brain, 'example', x$cube)
  x$add_to_brain(brain, 'example')

  brain$plot(controllers = list(
    "Voxel Type" = 'example',
    'Right Opacity' = 0.3,
    'Left Opacity' = 0.3,
    'Background Color' = '#000000'
  ), voxel_colormap = cmap)
}

}
