% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bijectors.R
\name{tfb_pad}
\alias{tfb_pad}
\title{Pads a value to the \code{event_shape} of a \code{Tensor}.}
\usage{
tfb_pad(
  paddings = list(c(0, 1)),
  mode = "CONSTANT",
  constant_values = 0,
  axis = NULL,
  validate_args = FALSE,
  name = NULL
)
}
\arguments{
\item{paddings}{A vector-shaped \code{Tensor} of \code{integer} pairs representing the number
of elements to pad on the left and right, respectively.
Default value: \code{list(reticulate::tuple(0L, 1L))}.}

\item{mode}{One of \code{'CONSTANT'}, \code{'REFLECT'}, or \code{'SYMMETRIC'}
(case-insensitive). For more details, see \code{tf$pad}.}

\item{constant_values}{In "CONSTANT" mode, the scalar pad value to use. Must be
same type as \code{tensor}. For more details, see \code{tf$pad}.}

\item{axis}{The dimensions for which \code{paddings} are applied. Must be 1:1 with
\code{paddings} or \code{NULL}.
Default value: \code{NULL} (i.e., \code{tf$range(start = -length(paddings), limit = 0)}).}

\item{validate_args}{Logical, default FALSE. Whether to validate input with asserts. If validate_args is
FALSE, and the inputs are invalid, correct behavior is not guaranteed.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a bijector instance.
}
\description{
The semantics of \code{bijector_pad} generally follow that of \code{tf$pad()}
except that \code{bijector_pad}'s \code{paddings} argument applies to the rightmost
dimensions. Additionally, the new argument \code{axis} enables overriding the
dimensions to which \code{paddings} is applied. Like \code{paddings}, the \code{axis}
argument is also relative to the rightmost dimension and must therefore be
negative.
The argument \code{paddings} is a vector of \code{integer} pairs each representing the
number of left and/or right \code{constant_values} to pad to the corresponding
righmost dimensions. That is, unless \code{axis} is specified\verb{, specifiying }k\code{different}paddings\verb{means the rightmost}k\verb{dimensions will be "grown" by the sum of the respective}paddings\verb{row. When}axis\verb{is specified, it indicates the dimension to which the corresponding}paddings\verb{element is applied. By default}axis\code{is}NULL\verb{which means it is logically equivalent to}range(start=-len(paddings), limit=0)`, i.e., the rightmost dimensions.
}
\seealso{
For usage examples see \code{\link[=tfb_forward]{tfb_forward()}}, \code{\link[=tfb_inverse]{tfb_inverse()}}, \code{\link[=tfb_inverse_log_det_jacobian]{tfb_inverse_log_det_jacobian()}}.

Other bijectors: 
\code{\link{tfb_absolute_value}()},
\code{\link{tfb_affine}()},
\code{\link{tfb_affine_linear_operator}()},
\code{\link{tfb_affine_scalar}()},
\code{\link{tfb_ascending}()},
\code{\link{tfb_batch_normalization}()},
\code{\link{tfb_blockwise}()},
\code{\link{tfb_chain}()},
\code{\link{tfb_cholesky_outer_product}()},
\code{\link{tfb_cholesky_to_inv_cholesky}()},
\code{\link{tfb_correlation_cholesky}()},
\code{\link{tfb_cumsum}()},
\code{\link{tfb_discrete_cosine_transform}()},
\code{\link{tfb_exp}()},
\code{\link{tfb_expm1}()},
\code{\link{tfb_ffjord}()},
\code{\link{tfb_fill_scale_tri_l}()},
\code{\link{tfb_fill_triangular}()},
\code{\link{tfb_glow}()},
\code{\link{tfb_gompertz_cdf}()},
\code{\link{tfb_gumbel}()},
\code{\link{tfb_gumbel_cdf}()},
\code{\link{tfb_identity}()},
\code{\link{tfb_inline}()},
\code{\link{tfb_invert}()},
\code{\link{tfb_iterated_sigmoid_centered}()},
\code{\link{tfb_kumaraswamy}()},
\code{\link{tfb_kumaraswamy_cdf}()},
\code{\link{tfb_lambert_w_tail}()},
\code{\link{tfb_masked_autoregressive_default_template}()},
\code{\link{tfb_masked_autoregressive_flow}()},
\code{\link{tfb_masked_dense}()},
\code{\link{tfb_matrix_inverse_tri_l}()},
\code{\link{tfb_matvec_lu}()},
\code{\link{tfb_normal_cdf}()},
\code{\link{tfb_ordered}()},
\code{\link{tfb_permute}()},
\code{\link{tfb_power_transform}()},
\code{\link{tfb_rational_quadratic_spline}()},
\code{\link{tfb_rayleigh_cdf}()},
\code{\link{tfb_real_nvp}()},
\code{\link{tfb_real_nvp_default_template}()},
\code{\link{tfb_reciprocal}()},
\code{\link{tfb_reshape}()},
\code{\link{tfb_scale}()},
\code{\link{tfb_scale_matvec_diag}()},
\code{\link{tfb_scale_matvec_linear_operator}()},
\code{\link{tfb_scale_matvec_lu}()},
\code{\link{tfb_scale_matvec_tri_l}()},
\code{\link{tfb_scale_tri_l}()},
\code{\link{tfb_shift}()},
\code{\link{tfb_shifted_gompertz_cdf}()},
\code{\link{tfb_sigmoid}()},
\code{\link{tfb_sinh}()},
\code{\link{tfb_sinh_arcsinh}()},
\code{\link{tfb_softmax_centered}()},
\code{\link{tfb_softplus}()},
\code{\link{tfb_softsign}()},
\code{\link{tfb_split}()},
\code{\link{tfb_square}()},
\code{\link{tfb_tanh}()},
\code{\link{tfb_transform_diagonal}()},
\code{\link{tfb_transpose}()},
\code{\link{tfb_weibull}()},
\code{\link{tfb_weibull_cdf}()}
}
\concept{bijectors}
