% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq2seq.R
\name{sampler_scheduled_embedding_training}
\alias{sampler_scheduled_embedding_training}
\title{A training sampler that adds scheduled sampling}
\usage{
sampler_scheduled_embedding_training(
  sampling_probability,
  embedding_fn = NULL,
  time_major = FALSE,
  seed = NULL,
  scheduling_seed = NULL
)
}
\arguments{
\item{sampling_probability}{A float32 0-D or 1-D tensor: the probability of sampling
categorically from the output ids instead of reading directly from the inputs.}

\item{embedding_fn}{A callable that takes a vector tensor of ids (argmax ids), or the
params argument for embedding_lookup.}

\item{time_major}{bool. Whether the tensors in inputs are time major. If `FALSE`
(default), they are assumed to be batch major.}

\item{seed}{The sampling seed.}

\item{scheduling_seed}{The schedule decision rule sampling seed.}
}
\value{
Returns -1s for sample_ids where no sampling took place; valid sample id values elsewhere.
}
\description{
A training sampler that adds scheduled sampling
}
