% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_text_logicals.R
\name{which_are}
\alias{which_are}
\alias{is_it}
\title{Detect/Locate Potential Non-Normalized Text}
\usage{
which_are()

is_it()
}
\value{
\code{which_are} returns an environment of functions that can be used to 
locate and return the integer locations of the particular non-normalized text
named by the function.

\code{is_it} returns an environment of functions that can be used to 
detect and return a logical atomic vector of equal length to the input vector
(except for meta functions) of the particular non-normalized text
named by the function.
}
\description{
Detect/Locate potential issues with text data.  This family of functions 
generates a list of detections/location functions that can be accessed via 
the dollar sign or square bracket operators.  Accessible functions include:
}
\details{
\describe{
  \item{contraction}{Contains contractions}
  \item{date}{Contains dates}
  \item{digit}{Contains digits}
  \item{email}{Contains email addresses}
  \item{emoticon}{Contains emoticons}
  \item{empty}{Contains just white space}
  \item{escaped}{Contains escaped backslash character}
  \item{hash}{Contains Twitter style hash tags}
  \item{html}{Contains html mark-up}
  \item{incomplete}{Contains incomplete sentences (e.g., ends with ...)}
  \item{kern}{Contains kerning (e.g. "The B O M B!")}
  \item{list_column}{Is a list of atomic vectors (Not provided by \code{which_are}))}
  \item{misspelled}{Contains potentially misspelled words}
  \item{no_endmark}{Contains a sentence with no ending punctuation}
  \item{no_space_after_comma}{Contains commas with no space after them}
  \item{non_ascii}{Contains non-ASCII characters}
  \item{non_character}{Is a non-character vector (Not provided by \code{which_are}))}
  \item{non_split_sentence}{Contains non split sentences}
  \item{tag}{Contains a Twitter style handle used to tag others (use of the at symbol)}
  \item{time}{Contains a time stamp}
  \item{url}{Contains a URL}
}

The functions above that have a description starting with 'is' rather than 'contains'
are meta functions that describe the attribute of the column/vector being passed
rather than attributes about the individual elements of the column/vector.  The
meta functions will return a logical of length one and are not available under
\code{which_are}.
}
\examples{
wa <- which_are()
it <- is_it()
wa$digit(c('The dog',  "I like 2", NA))
it$digit(c('The dog',  "I like 2", NA))

is_it()$list_column(c('the dog', 'ate the chicken'))

}
