% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\docType{class}
\name{big_tokenize_transform}
\alias{big_tokenize_transform}
\title{String tokenization and transformation for big data sets}
\usage{
# utl <- big_tokenize_transform$new(verbose = FALSE)
}
\description{
String tokenization and transformation for big data sets

String tokenization and transformation for big data sets
}
\details{
the \emph{big_text_splitter} function splits a text file into sub-text-files using either the batches parameter (big-text-splitter-bytes) or both the batches and the end_query parameter (big-text-splitter-query). The end_query parameter (if not NULL) should be a character string specifying a word that appears repeatedly at the end of each line in the text file.

the \emph{big_text_parser} function parses text files from an input folder and saves those processed files to an output folder. The \emph{big_text_parser} is appropriate for files with a structure using the start- and end- query parameters.

the \emph{big_text_tokenizer} function tokenizes and transforms the text files of a folder and saves those files to either a folder or a single file. There is also the option to save a frequency vocabulary of those transformed tokens to a file.

the \emph{vocabulary_accumulator} function takes the resulted vocabulary files of the \emph{big_text_tokenizer} and returns the vocabulary sums sorted in decreasing order. The parameter \emph{max_num_chars} limits the number of the corpus using the number of characters of each word.

The \emph{ngram_sequential} or \emph{ngram_overlap} stemming method applies to each single batch and not to the whole corpus of the text file. Thus, it is possible that the stems of the same words for randomly selected batches might differ.
}
\section{Methods}{


\describe{
 \item{\code{big_tokenize_transform$new(verbose = FALSE)}}{}

 \item{\code{--------------}}{}

 \item{\code{big_text_splitter(input_path_file = NULL, output_path_folder = NULL, end_query = NULL, batches = NULL, trimmed_line = FALSE)}}{}

 \item{\code{--------------}}{}

 \item{\code{big_text_parser(input_path_folder = NULL, output_path_folder = NULL, start_query = NULL, end_query = NULL, min_lines = 1, trimmed_line = FALSE)}}{}

 \item{\code{--------------}}{}

 \item{\code{big_text_tokenizer(input_path_folder = NULL, batches = NULL, read_file_delimiter = " ", to_lower = FALSE, to_upper = FALSE, utf_locale = "", remove_char = "", remove_punctuation_string = FALSE, remove_punctuation_vector = FALSE, remove_numbers = FALSE, trim_token = FALSE, split_string = FALSE, split_separator = " .,;:()?!", remove_stopwords = FALSE, language = "english", min_num_char = 1, max_num_char = Inf, stemmer = NULL, min_n_gram = 1, max_n_gram = 1, skip_n_gram = 1, skip_distance = 0, n_gram_delimiter = " ", concat_delimiter = NULL, path_2folder = "", stemmer_ngram = 4, stemmer_gamma = 0.0, stemmer_truncate = 3, stemmer_batches = 1, threads = 1, save_2single_file = FALSE, increment_batch_nr = 1, vocabulary_path_folder = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{vocabulary_accumulator(input_path_folder = NULL, vocabulary_path_file = NULL, max_num_chars = 100)}}{}
 }
}

\examples{

\dontrun{

library(textTinyR)

fs <- big_tokenize_transform$new(verbose = FALSE)

#---------------
# file splitter:
#---------------

fs$big_text_splitter(input_path_file = "input.txt",
                     output_path_folder = "/folder/output/",
                     end_query = "endword", batches = 5,
                     trimmed_line = FALSE)


#-------------
# file parser:
#-------------

fs$big_text_parser(input_path_folder = "/folder/output/",
                    output_path_folder = "/folder/parser/",
                    start_query = "startword", end_query = "endword",
                    min_lines = 1, trimmed_line = TRUE)


#----------------
# file tokenizer:
#----------------


 fs$big_text_tokenizer(input_path_folder = "/folder/parser/",
                       batches = 5, split_string=TRUE,
                       to_lower = TRUE, trim_token = TRUE,
                       max_num_char = 100, remove_stopwords = TRUE,
                       stemmer = "porter2_stemmer", threads = 1,
                       path_2folder="/folder/output_token/",
                       vocabulary_path_folder="/folder/VOCAB/")

#-------------------
# vocabulary counts:
#-------------------


fs$vocabulary_accumulator(input_path_folder = "/folder/VOCAB/",
                           vocabulary_path_file = "/folder/vocab.txt",
                           max_num_chars = 50)

}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-big_tokenize_transform-new}{\code{big_tokenize_transform$new()}}
\item \href{#method-big_tokenize_transform-big_text_splitter}{\code{big_tokenize_transform$big_text_splitter()}}
\item \href{#method-big_tokenize_transform-big_text_parser}{\code{big_tokenize_transform$big_text_parser()}}
\item \href{#method-big_tokenize_transform-big_text_tokenizer}{\code{big_tokenize_transform$big_text_tokenizer()}}
\item \href{#method-big_tokenize_transform-vocabulary_accumulator}{\code{big_tokenize_transform$vocabulary_accumulator()}}
\item \href{#method-big_tokenize_transform-clone}{\code{big_tokenize_transform$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-big_tokenize_transform-new"></a>}}
\if{latex}{\out{\hypertarget{method-big_tokenize_transform-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{big_tokenize_transform$new(verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{either TRUE or FALSE. If TRUE then information will be printed in the console}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-big_tokenize_transform-big_text_splitter"></a>}}
\if{latex}{\out{\hypertarget{method-big_tokenize_transform-big_text_splitter}{}}}
\subsection{Method \code{big_text_splitter()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{big_tokenize_transform$big_text_splitter(
  input_path_file = NULL,
  output_path_folder = NULL,
  end_query = NULL,
  batches = NULL,
  trimmed_line = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input_path_file}}{a character string specifying the path to the input file}

\item{\code{output_path_folder}}{a character string specifying the folder where the output files should be saved}

\item{\code{end_query}}{a character string. The \emph{end_query} is the last word of the subset of the data and should appear frequently at the end of each line in the text file.}

\item{\code{batches}}{a numeric value specifying the number of batches to use. The batches will be used to split the initial data into subsets. Those subsets will be either saved in files (\emph{big_text_splitter} function) or will be used internally for low memory processing (\emph{big_text_tokenizer} function).}

\item{\code{trimmed_line}}{either TRUE or FALSE. If FALSE then each line of the text file will be trimmed both sides before applying the start_query and end_query}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-big_tokenize_transform-big_text_parser"></a>}}
\if{latex}{\out{\hypertarget{method-big_tokenize_transform-big_text_parser}{}}}
\subsection{Method \code{big_text_parser()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{big_tokenize_transform$big_text_parser(
  input_path_folder = NULL,
  output_path_folder = NULL,
  start_query = NULL,
  end_query = NULL,
  min_lines = 1,
  trimmed_line = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input_path_folder}}{a character string specifying the folder where the input files are saved}

\item{\code{output_path_folder}}{a character string specifying the folder where the output files should be saved}

\item{\code{start_query}}{a character string. The \emph{start_query} is the first word of the subset of the data and should appear frequently at the beginning of each line int the text file.}

\item{\code{end_query}}{a character string. The \emph{end_query} is the last word of the subset of the data and should appear frequently at the end of each line in the text file.}

\item{\code{min_lines}}{a numeric value specifying the minimum number of lines. For instance if min_lines = 2, then only subsets of text with more than 1 lines will be kept.}

\item{\code{trimmed_line}}{either TRUE or FALSE. If FALSE then each line of the text file will be trimmed both sides before applying the start_query and end_query}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-big_tokenize_transform-big_text_tokenizer"></a>}}
\if{latex}{\out{\hypertarget{method-big_tokenize_transform-big_text_tokenizer}{}}}
\subsection{Method \code{big_text_tokenizer()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{big_tokenize_transform$big_text_tokenizer(
  input_path_folder = NULL,
  batches = NULL,
  read_file_delimiter = "\\n",
  to_lower = FALSE,
  to_upper = FALSE,
  utf_locale = "",
  remove_char = "",
  remove_punctuation_string = FALSE,
  remove_punctuation_vector = FALSE,
  remove_numbers = FALSE,
  trim_token = FALSE,
  split_string = FALSE,
  split_separator = " \\r\\n\\t.,;:()?!//",
  remove_stopwords = FALSE,
  language = "english",
  min_num_char = 1,
  max_num_char = Inf,
  stemmer = NULL,
  min_n_gram = 1,
  max_n_gram = 1,
  skip_n_gram = 1,
  skip_distance = 0,
  n_gram_delimiter = " ",
  concat_delimiter = NULL,
  path_2folder = "",
  stemmer_ngram = 4,
  stemmer_gamma = 0,
  stemmer_truncate = 3,
  stemmer_batches = 1,
  threads = 1,
  save_2single_file = FALSE,
  increment_batch_nr = 1,
  vocabulary_path_folder = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input_path_folder}}{a character string specifying the folder where the input files are saved}

\item{\code{batches}}{a numeric value specifying the number of batches to use. The batches will be used to split the initial data into subsets. Those subsets will be either saved in files (\emph{big_text_splitter} function) or will be used internally for low memory processing (\emph{big_text_tokenizer} function).}

\item{\code{read_file_delimiter}}{the delimiter to use when the input file will be red (for instance a tab-delimiter or a new-line delimiter).}

\item{\code{to_lower}}{either TRUE or FALSE. If TRUE the character string will be converted to lower case}

\item{\code{to_upper}}{either TRUE or FALSE. If TRUE the character string will be converted to upper case}

\item{\code{utf_locale}}{the language specific locale to use in case that either the \emph{to_lower} or the \emph{to_upper} parameter is TRUE and the text file language is other than english. For instance if the language of a text file is greek then the \emph{utf_locale} parameter should be \emph{'el_GR.UTF-8'} ( \emph{language_country.encoding} ). A wrong utf-locale does not raise an error, however the runtime of the function increases.}

\item{\code{remove_char}}{a character string with specific characters that should be removed from the text file. If the \emph{remove_char} is "" then no removal of characters take place}

\item{\code{remove_punctuation_string}}{either TRUE or FALSE. If TRUE then the punctuation of the character string will be removed (applies before the split function)}

\item{\code{remove_punctuation_vector}}{either TRUE or FALSE. If TRUE then the punctuation of the vector of the character strings will be removed  (after the string split has taken place)}

\item{\code{remove_numbers}}{either TRUE or FALSE. If TRUE then any numbers in the character string will be removed}

\item{\code{trim_token}}{either TRUE or FALSE. If TRUE then the string will be trimmed (left and/or right)}

\item{\code{split_string}}{either TRUE or FALSE. If TRUE then the character string will be split using the \emph{split_separator} as delimiter. The user can also specify multiple delimiters.}

\item{\code{split_separator}}{a character string specifying the character delimiter(s)}

\item{\code{remove_stopwords}}{either TRUE, FALSE or a character vector of user defined stop words. If TRUE then by using the \emph{language} parameter the corresponding stop words vector will be uploaded.}

\item{\code{language}}{a character string which defaults to english. If the \emph{remove_stopwords} parameter is TRUE then the corresponding stop words vector will be uploaded. Available languages
are \emph{afrikaans}, \emph{arabic}, \emph{armenian}, \emph{basque}, \emph{bengali}, \emph{breton}, \emph{bulgarian}, \emph{catalan},
\emph{croatian}, \emph{czech}, \emph{danish}, \emph{dutch}, \emph{english}, \emph{estonian},
\emph{finnish}, \emph{french}, \emph{galician}, \emph{german}, \emph{greek}, \emph{hausa}, \emph{hebrew}, \emph{hindi}, \emph{hungarian},
\emph{indonesian}, \emph{irish}, \emph{italian}, \emph{latvian}, \emph{marathi},
\emph{norwegian}, \emph{persian}, \emph{polish}, \emph{portuguese}, \emph{romanian}, \emph{russian}, \emph{slovak}, \emph{slovenian},
\emph{somalia}, \emph{spanish}, \emph{swahili}, \emph{swedish}, \emph{turkish}, \emph{yoruba}, \emph{zulu}}

\item{\code{min_num_char}}{an integer specifying the minimum number of characters to keep. If the \emph{min_num_char} is greater than 1 then character strings with more than 1 characters will be returned}

\item{\code{max_num_char}}{an integer specifying the maximum number of characters to keep. The \emph{max_num_char} should be less than or equal to \emph{Inf} (in this function the Inf value translates to a word-length of 1000000000)}

\item{\code{stemmer}}{a character string specifying the stemming method. One of the following \emph{porter2_stemmer}, \emph{ngram_sequential}, \emph{ngram_overlap}. See details for more information.}

\item{\code{min_n_gram}}{an integer specifying the minimum number of n-grams. The minimum number of min_n_gram is 1.}

\item{\code{max_n_gram}}{an integer specifying the maximum number of n-grams. The minimum number of max_n_gram is 1.}

\item{\code{skip_n_gram}}{an integer specifying the number of skip-n-grams. The minimum number of skip_n_gram is 1. The skip_n_gram gives the (max.) n-grams using the \emph{skip_distance} parameter. If \emph{skip_n_gram} is greater than 1 then both \emph{min_n_gram} and \emph{max_n_gram} should be set to 1.}

\item{\code{skip_distance}}{an integer specifying the skip distance between the words. The minimum value for the skip distance is 0, in which case simple n-grams will be returned.}

\item{\code{n_gram_delimiter}}{a character string specifying the n-gram delimiter (applies to both n-gram and skip-n-gram cases)}

\item{\code{concat_delimiter}}{either NULL or a character string specifying the delimiter to use in order to concatenate the end-vector of character strings to a single character string (recommended in case that the end-vector should be saved to a file)}

\item{\code{path_2folder}}{a character string specifying the path to the folder where the file(s) will be saved}

\item{\code{stemmer_ngram}}{a numeric value greater than 1. Applies to both \emph{ngram_sequential} and \emph{ngram_overlap} methods. In case of \emph{ngram_sequential} the first stemmer_ngram characters will be picked, whereas in the case of \emph{ngram_overlap} the overlapping stemmer_ngram characters will be build.}

\item{\code{stemmer_gamma}}{a float number greater or equal to 0.0. Applies only to \emph{ngram_sequential}. Is a threshold value, which defines how much frequency deviation of two N-grams is acceptable. It is kept either zero or to a minimum value.}

\item{\code{stemmer_truncate}}{a numeric value greater than 0. Applies only to \emph{ngram_sequential}. The ngram_sequential is modified to use relative frequencies (float numbers between 0.0 and 1.0 for the ngrams of a specific word in the corpus) and the stemmer_truncate parameter controls the number of rounding digits for the ngrams of the word. The main purpose was to give the same relative frequency to words appearing approximately the same on the corpus.}

\item{\code{stemmer_batches}}{a numeric value greater than 0. Applies only to \emph{ngram_sequential}. Splits the corpus into batches with the option to run the batches in multiple threads.}

\item{\code{threads}}{an integer specifying the number of cores to run in parallel}

\item{\code{save_2single_file}}{either TRUE or FALSE. If TRUE then the output data will be saved in a single file. Otherwise the data will be saved in multiple files with incremented enumeration}

\item{\code{increment_batch_nr}}{a numeric value. The enumeration of the output files will start from the \emph{increment_batch_nr}. If the \emph{save_2single_file} parameter is TRUE then the \emph{increment_batch_nr} parameter won't be taken into consideration.}

\item{\code{vocabulary_path_folder}}{either NULL or a character string specifying the output folder where the vocabulary batches should be saved (after tokenization and transformation is applied). Applies to the \emph{big_text_tokenizer} method.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-big_tokenize_transform-vocabulary_accumulator"></a>}}
\if{latex}{\out{\hypertarget{method-big_tokenize_transform-vocabulary_accumulator}{}}}
\subsection{Method \code{vocabulary_accumulator()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{big_tokenize_transform$vocabulary_accumulator(
  input_path_folder = NULL,
  vocabulary_path_file = NULL,
  max_num_chars = 100
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input_path_folder}}{a character string specifying the folder where the input files are saved}

\item{\code{vocabulary_path_file}}{either NULL or a character string specifying the output file where the vocabulary should be saved (after tokenization and transformation is applied). Applies to the \emph{vocabulary_accumulator} method.}

\item{\code{max_num_chars}}{a numeric value to limit the words of the output vocabulary to a maximum number of characters (applies to the \emph{vocabulary_accumulator} function)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-big_tokenize_transform-clone"></a>}}
\if{latex}{\out{\hypertarget{method-big_tokenize_transform-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{big_tokenize_transform$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
