% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_spatial_rgb.R
\docType{data}
\name{geom_spatial_rgb}
\alias{geom_spatial_rgb}
\alias{StatSpatialRGB}
\alias{stat_spatial_rgb}
\title{Plot RGB rasters in ggplot2}
\usage{
geom_spatial_rgb(
  mapping = NULL,
  data = NULL,
  stat = "spatialRGB",
  position = "identity",
  ...,
  hjust = 0.5,
  vjust = 0.5,
  interpolate = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  scale = NULL
)

stat_spatial_rgb(
  mapping = NULL,
  data = NULL,
  geom = "raster",
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  scale = NULL,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. In addition to the three
options described in \link[ggplot2:geom_tile]{ggplot2::geom_raster}, there are two additional
methods:

If a \code{SpatRaster} object (see \link[terra:rast]{terra::rast}), this function will coerce
the raster to a data frame and assume the raster bands are in RGB order
(while allowing for, but ignoring, a fourth alpha band).

If a length-1 character vector, this function will attempt to load the object
via \link[terra:rast]{terra::rast}.}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{hjust, vjust}{horizontal and vertical justification of the grob.  Each
justification value should be a number between 0 and 1.  Defaults to 0.5
for both, centering each pixel over its data location.}

\item{interpolate}{If \code{TRUE} interpolate linearly, if \code{FALSE}
(the default) don't interpolate.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{scale}{Integer. Maximum (possible) value in the three channels.
If \code{NULL}, attempts to infer proper values from data -- if all RGB values
are <= 1 then 1, <= 255 then 255, and otherwise 65535.}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}
}
\description{
\code{geom_spatial_rgb} and \code{stat_spatial_rgb} allow users to plot three-band RGB
rasters in ggplot2, using these layers as background base maps for other
spatial plotting. Note that unlike \link[ggplot2:ggsf]{ggplot2::geom_sf}, this function does
\emph{not} force \link[ggplot2:ggsf]{ggplot2::coord_sf}; for accurate mapping, add
\link[ggplot2:ggsf]{ggplot2::coord_sf} with a \code{crs} value matching your input raster as a layer.
}
\examples{
\dontrun{

simulated_data <- data.frame(
  id = seq(1, 100, 1),
  lat = runif(100, 44.04905, 44.17609),
  lng = runif(100, -74.01188, -73.83493)
)

simulated_data <- sf::st_as_sf(simulated_data, coords = c("lng", "lat"))
simulated_data <- sf::st_set_crs(simulated_data, 4326)

output_tiles <- get_tiles(simulated_data,
  services = c("ortho"),
  resolution = 120
)

merged_ortho <- tempfile(fileext = ".tif")
merge_rasters(output_tiles[["ortho"]], merged_ortho)

merged_stack <- terra::rast(merged_ortho)

library(ggplot2)

ggplot() +
  geom_spatial_rgb(
    data = merged_ortho,
    mapping = aes(
      x = x,
      y = y,
      r = red,
      g = green,
      b = blue
    )
  ) +
  geom_sf(data = simulated_data) +
  coord_sf(crs = 4326)

ggplot() +
  geom_spatial_rgb(
    data = merged_stack,
    mapping = aes(
      x = x,
      y = y,
      r = red,
      g = green,
      b = blue
    )
  ) +
  geom_sf(data = simulated_data) +
  coord_sf(crs = 4326)
}

}
\seealso{
Other visualization functions: 
\code{\link{combine_overlays}()},
\code{\link{raster_to_raw_tiles}()},
\code{\link{vector_to_overlay}()}
}
\concept{visualization functions}
\keyword{datasets}
