% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{range_noinf}
\alias{range_noinf}
\title{Re-implemented \code{range()} default S3 method for numerical objects}
\usage{
range_noinf(x, na.rm = FALSE, finite = FALSE)
}
\arguments{
\item{x}{(\code{numeric})\cr a sequence of numbers for which the range is computed.}

\item{na.rm}{(\code{flag})\cr flag indicating if \code{NA} should be omitted.}

\item{finite}{(\code{flag})\cr flag indicating if non-finite elements should be removed.}
}
\value{
A 2-element vector of class \code{numeric}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function returns \code{c(NA, NA)} instead of \code{c(-Inf, Inf)} for zero-length data
without any warnings.
}
\examples{
x <- rnorm(20, 1)
range_noinf(x, na.rm = TRUE)
range_noinf(rep(NA, 20), na.rm = TRUE)
range(rep(NA, 20), na.rm = TRUE)

}
