% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.duration.R
\name{nodefactor.mean.age-ergmTerm}
\alias{nodefactor.mean.age-ergmTerm}
\alias{InitErgmTerm.nodefactor.mean.age}
\title{Average ages of extant half-ties incident on nodes of specified attribute levels}
\usage{
# binary: nodefactor.mean.age(attr, levels=NULL, emptyval=0, log=FALSE)
}
\arguments{
\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{levels}{controls what levels are included. Note that the default
\code{levels} value for \code{nodefactor.mean.age} retains all levels, unlike the default
for \code{nodefactor} , which omits the first level.}

\item{emptyval}{can be used to specify the value returned if the network is empty. A different value may be
specified for each level of \code{attr}. The length of \code{emptyval} should either be 1 (in which case that value
is used for every level of \code{attr} ) or should be equal to the number of retained levels of \code{attr} , in
which case the \code{i} th value in \code{emptyval} is used for the \code{i} th retained level of \code{attr}. This is,
technically, an arbitrary value, but it should
not have a substantial effect unless a non-negligible fraction of
networks at the parameter configuration of interest is empty.}

\item{log}{logical specifying if mean log age should be returned instead of mean age}
}
\description{
Average ages of extant half-ties incident on nodes of specified attribute levels
}
\details{
This term adds one statistic for each level of \code{attr} ,
equaling the average, over all half-ties incident on nodes of that level,
of the amount of time elapsed since formation.
}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "nodefactor.mean.age", "subsection")}
}
\concept{durational}
